/*
 * Decompiled with CFR 0.152.
 */
package com.sccba.open.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static MessageDigest messagedigest;

    static {
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsaex) {
            System.err.println(String.valueOf(MD5Util.class.getName()) + "\u521d\u59cb\u5316\u5931\u8d25\uff0cMessageDigest\u4e0d\u652f\u6301MD5Util");
        }
    }

    public static synchronized String getFileMD5String(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        FileChannel ch = in.getChannel();
        MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        messagedigest.update(byteBuffer);
        if (ch != null) {
            ch.close();
        }
        if (in != null) {
            in.close();
        }
        return MD5Util.bufferToHex(messagedigest.digest());
    }

    public static String getFileMD5StringForSmallFile(File file) throws IOException {
        if (MD5Util.getFileSizes(file) > 0x100000L) {
            return "";
        }
        FileInputStream in = new FileInputStream(file);
        FileChannel ch = in.getChannel();
        MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        messagedigest.update(byteBuffer);
        if (ch != null) {
            ch.close();
        }
        if (in != null) {
            in.close();
        }
        return MD5Util.bufferToHex(messagedigest.digest());
    }

    public static long getFileSizes(File f) throws IOException {
        long s = 0L;
        if (f.exists()) {
            FileInputStream fis = null;
            fis = new FileInputStream(f);
            s = fis.available();
        }
        return s;
    }

    public static String getMD5String(String s) {
        return MD5Util.getMD5String(s.getBytes());
    }

    public static String getMD5String(byte[] bytes) {
        messagedigest.update(bytes);
        return MD5Util.bufferToHex(messagedigest.digest());
    }

    private static String bufferToHex(byte[] bytes) {
        return MD5Util.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        int l = m;
        while (l < k) {
            MD5Util.appendHexPair(bytes[l], stringbuffer);
            ++l;
        }
        return stringbuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xF0) >> 4];
        char c1 = hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }

    public static boolean checkPassword(String password, String md5PwdStr) {
        String s = MD5Util.getMD5String(password);
        return s.equals(md5PwdStr);
    }
}

