package cn.com.wawa.manager.biz.bean;

import cn.com.wawa.service.api.bean.JsonResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.util.List;

@Data
@ApiModel("娃娃类目保存bean")
public class WawaCategorySaveBean {

    @ApiModelProperty("主键ID")
    private long id;

    @ApiModelProperty(value = "类目名称", required = true)
    private String categoryName;

    @ApiModelProperty("娃娃 ids")
    private List<WawaPayloadBean> wawaIds;

    @ApiModelProperty(value = "上线时间", required = true)
    private String onlineTimeStr;

    @ApiModelProperty(value = "下线时间", required = true)
    private String offlineTimeStr;

    public JsonResult check() {
        if (StringUtils.isBlank(categoryName)) {
            return JsonResult.failedResult("类目名称不能为空");
        }
        if (categoryName.length() > 20) {
            return JsonResult.failedResult("类目名称长度不能超过20");
        }
        return null;
    }

}
