package cn.com.wawa.manager.biz.bean.title;

import cn.com.wawa.service.api.bean.JsonResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/**
 * @author huangjunping
 */
@Data
@ApiModel("称号配置保存bean")
public class TitleConfigSaveBean {

    @ApiModelProperty("主键ID")
    private int id;

    @ApiModelProperty(value = "称号名称", required = true)
    private String name;

    @ApiModelProperty(value = "称号图片", required = true)
    private String image;

    @ApiModelProperty(value = "称号类型 1.成就 2.活动", required = true)
    private int type = 1;

    @ApiModelProperty(value = "二级类别 11.累充 12.累计娃娃 13.连续抓中 14.一爪抓多只 21.充值排行榜 22.抓中排行榜", required = true)
    private int secondType = 11;

    @ApiModelProperty("上限条件 充值单位为元，抓中娃娃单位为只；type = 2，该字段有用")
    private int upperLimit;

    @ApiModelProperty(value = "下限条件 充值单位为元，抓中娃娃单位为只", required = true)
    private int lowerLimit;

    @ApiModelProperty("获取条件文案")
    private String description;

    @ApiModelProperty(value = "称号等级ID", required = true)
    private int levelId;

    @ApiModelProperty(value = "有效天数 -1.永久", required = true)
    private int validDays = -1;

    @ApiModelProperty(value = "是否展示称号进度 true false", required = true)
    private boolean progressShow = false;

    @ApiModelProperty(value = "获得的称号是否浮层展示 true false", required = true)
    private boolean supernatantShow = false;

    @ApiModelProperty("称号备注")
    private String remark;

    @ApiModelProperty("称号状态 0.未上线 1.上线中 2. 已下线 3. 归档")
    private int status;

    @ApiModelProperty(value = "上线时间", required = true)
    private String onlineTime;

    @ApiModelProperty(value = "下线时间", required = true)
    private String offlineTime;

    public static final int[] SECOND_TYPE_1 = {11, 12, 13, 14};

    public static final int[] SECOND_TYPE_2 = {21, 22};

    public JsonResult check4Add() {
        return check();
    }

    private JsonResult check() {
        if (StringUtils.isBlank(name)) {
            return JsonResult.failedResult("称号名称不能为空");
        }
        if (name.length() > 20) {
            return JsonResult.failedResult("称号名称长度不能超过20");
        }

        if (StringUtils.isBlank(image)) {
            return JsonResult.failedResult("称号图片不能为空");
        }
        if (image.length() > 256) {
            return JsonResult.failedResult("称号图片地址过长");
        }

        if (type > 2 || type < 1) {
            return JsonResult.failedResult("称号类型输入值无效");
        }

        if (type == 1) {
            if (!ArrayUtils.contains(SECOND_TYPE_1, secondType)) {
                return JsonResult.failedResult("二级类别输入值无效");
            }
            upperLimit = 0;
        } else {
            if (!ArrayUtils.contains(SECOND_TYPE_2, secondType)) {
                return JsonResult.failedResult("二级类别输入值无效");
            }
            if (upperLimit <= 0 || upperLimit < lowerLimit) {
                return JsonResult.failedResult("上限条件值输入无效");
            }
        }

        if (lowerLimit <= 0) {
            return JsonResult.failedResult("下限条件值输入无效");
        }

        if (levelId == 0) {
            return JsonResult.failedResult("请选择称号等级");
        }

        if (validDays < -1 || validDays == 0) {
            return JsonResult.failedResult("有效天数输入值无效");
        }

        if (remark != null && remark.length() > 20) {
            return JsonResult.failedResult("称号备注文案过长");
        }
        return null;
    }

    public JsonResult check4Update() {
        if (id < 1) {
            return JsonResult.failedResult("请选中需要修改的记录");
        }
        return check();
    }

}
