package cn.com.wawa.manager.biz.bean.title;

import cn.com.wawa.service.api.bean.JsonResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

/**
 * @author huangjunping
 */
@Data
@ApiModel("称号等级保存bean")
public class TitleLevelSaveBean {

    @ApiModelProperty("主键")
    private int id;

    @ApiModelProperty(value = "等级名称", required = true)
    private String name;

    @ApiModelProperty(value = "光影渲染效果 0.无 1.炫酷 2.普通",required = true)
    private int lightingRender;

    @ApiModelProperty(value = "头像框",required = true)
    private String avatarBox;

    @ApiModelProperty(value = "进房间是否有炫酷播报 true false",required = true)
    private boolean roomBroadcast = false;

    @ApiModelProperty(value = "聊天框中是否有炫酷播报 true false",required = true)
    private boolean chattingBroadcast = false;

    public JsonResult check4Add() {
        return check();
    }

    private JsonResult check() {
        if (StringUtils.isBlank(name)) {
            return JsonResult.failedResult("等级名称不能为空");
        }
        if (name.length() > 20) {
            return JsonResult.failedResult("等级名称长度不能超过20");
        }

        if (lightingRender > 2 || lightingRender < 0) {
            return JsonResult.failedResult("光影渲染效果输入值无效");
        }

        if (StringUtils.isBlank(avatarBox)) {
            return JsonResult.failedResult("头像框图片不能为空");
        }
        if (avatarBox.length() > 256) {
            return JsonResult.failedResult("头像框图片地址过长");
        }
        return null;
    }

    public JsonResult check4Update() {
        if (id < 1) {
            return JsonResult.failedResult("请选中需要修改的记录");
        }
        return check();
    }

}
