package cn.com.wawa.manager.biz.service;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.wawa.manager.biz.bean.BannerSaveRequestBean;
import cn.com.wawa.manager.biz.tools.LocalDateUtil;
import cn.com.wawa.manager.biz.vo.BannerVO;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.BannerDto;
import cn.com.wawa.service.api.remoteservice.RemoteBannerService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


@Service
public class BannerService {
    @Autowired
    private RemoteBannerService remoteBannerService;

    public BannerVO find(Long id) {
        BannerDto bannerDto = remoteBannerService.find(id);
        if (bannerDto != null) {
            return new BannerVO(bannerDto);
        }
        return null;
    }

    /**
     * 获取banner分页列表
     *
     * @param pageIndex
     * @param pageSize
     * @param status
     * @return
     */
    public PagerResponse<BannerVO> page(int pageIndex, int pageSize, Integer status, Integer bannerType, Integer userType, String bannerName) {
        PagerResponse<BannerDto> page = remoteBannerService.page(new PagerRequest(pageIndex, pageSize), status, bannerType, userType, bannerName);
        List<BannerVO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(page.getRecords())) {
            for (BannerDto bannerDto : page.getRecords()) {
                list.add(new BannerVO(bannerDto));
            }
        }
        return new PagerResponse<>(page, list);
    }

    /**
     * 新建或者保存bannerDto
     *
     * @param bannerSaveRequestBean
     * @return
     */
    public Boolean save(BannerSaveRequestBean bannerSaveRequestBean) {
        BannerDto bannerDto = BeanUtils.copy(bannerSaveRequestBean, BannerDto.class);

        if (StringUtils.isNotBlank(bannerSaveRequestBean.getOpenTime())) {
            bannerDto.setOpenTime(LocalDateUtil.getHoruDbDate(bannerSaveRequestBean.getOpenTime()));
        }
        if (StringUtils.isNotBlank(bannerSaveRequestBean.getCloseTime())) {
            bannerDto.setCloseTime(LocalDateUtil.getHoruDbDate(bannerSaveRequestBean.getCloseTime()));
        }
        Long chargeMoney = bannerSaveRequestBean.getChargeMoney();
        if(chargeMoney != null){
            bannerDto.setChargeMoney(chargeMoney * 100L);
        }
        return remoteBannerService.save(bannerDto);
    }


    public Date getHourStr(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH");
        try {
            return format.parse(date);
        } catch (ParseException e) {
            return null;
        }
    }


    /**
     * @param id
     * @return
     */
    public Boolean delete(Long id) {
        return remoteBannerService.delete(id);
    }

    public Boolean updateStatus(Long id, Integer status) {
        return remoteBannerService.setStatus(id, status);
    }


    public Boolean updatePayload(Long id, Long payload) {
        return remoteBannerService.setPayload(id, payload);
    }

    public Integer countByStatus(Integer status, Integer bannerType, Integer userType) {
        return remoteBannerService.countByStatus(status, bannerType, userType);
    }

}
