package cn.com.wawa.manager.biz.service;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.dto.groupbook.GroupBookDto;
import cn.com.wawa.service.api.dto.groupbook.GroupBookPage;
import cn.com.wawa.service.api.remoteservice.groupbook.RemoteGroupBookService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class GroupBookService {

    @Resource
    private RemoteGroupBookService remoteGroupBookService;

    public GroupBookPage list(Integer pageIndex, Integer pageSize) {
        return remoteGroupBookService.page(new PagerRequest(pageIndex, pageSize));
    }

    public GroupBookDto query(Long id) {
        return remoteGroupBookService.getGroupBookInfo(id);
    }

    public JsonResult online(Long id) {
        return remoteGroupBookService.onLine(id);
    }

    public JsonResult offline(Long id) {
        return remoteGroupBookService.offLine(id);
    }

    public JsonResult delete(Long id) {
        return remoteGroupBookService.delete(id);
    }

    public JsonResult updateSort(Long id, Integer sort) {
        return remoteGroupBookService.updateSort(sort, id);
    }

    public JsonResult save(GroupBookDto param) {
        return remoteGroupBookService.save(param);
    }
}
