package cn.com.wawa.manager.biz.service;

import cn.com.wawa.manager.biz.bean.title.TitleConfigSaveBean;
import cn.com.wawa.manager.biz.tools.LocalDateUtil;
import cn.com.wawa.manager.biz.vo.title.TitleConfigVO;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.title.TitleConfigDto;
import cn.com.wawa.service.api.remoteservice.title.RemoteTitleConfigService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class TitleConfigService {

    @Resource
    private RemoteTitleConfigService remoteTitleConfigService;

    public JsonResult add(TitleConfigSaveBean titleConfigSaveBean) {
        TitleConfigDto titleConfigDto = new TitleConfigDto();
        BeanUtils.copyProperties(titleConfigSaveBean, titleConfigDto);
        if (titleConfigSaveBean.isProgressShow()) {
            titleConfigDto.setProgressShow(1);
        }
        if (titleConfigSaveBean.isSupernatantShow()) {
            titleConfigDto.setSupernatantShow(1);
        }

        titleConfigDto.setOnlineTime(LocalDateUtil.getFullDate(titleConfigSaveBean.getOnlineTime()));
        titleConfigDto.setOfflineTime(LocalDateUtil.getFullDate(titleConfigSaveBean.getOfflineTime()));

        if (remoteTitleConfigService.add(titleConfigDto)) {
            return JsonResult.successResult("Success");
        }
        return JsonResult.failedResult("保存失败");
    }

    public JsonResult update(TitleConfigSaveBean titleConfigSaveBean) {
        TitleConfigDto titleConfigDto = remoteTitleConfigService.find(titleConfigSaveBean.getId());
        if (titleConfigDto == null) {
            return JsonResult.failedResult("数据不存在");
        }
        if (titleConfigDto.getStatus() > 1) {
            return JsonResult.failedResult("已下线和归档的记录不能修改");
        }

        BeanUtils.copyProperties(titleConfigSaveBean, titleConfigDto);
        if (titleConfigSaveBean.isProgressShow()) {
            titleConfigDto.setProgressShow(1);
        }
        if (titleConfigSaveBean.isSupernatantShow()) {
            titleConfigDto.setSupernatantShow(1);
        }

        titleConfigDto.setOnlineTime(LocalDateUtil.getFullDate(titleConfigSaveBean.getOnlineTime()));
        titleConfigDto.setOfflineTime(LocalDateUtil.getFullDate(titleConfigSaveBean.getOfflineTime()));

        if (remoteTitleConfigService.update(titleConfigDto)) {
            return JsonResult.successResult("Success");
        }
        return JsonResult.failedResult("保存失败");
    }

    public JsonResult updateStatus(int id, int status) {
        TitleConfigDto titleConfigDto = remoteTitleConfigService.find(id);
        if (titleConfigDto == null) {
            return JsonResult.failedResult("数据不存在");
        }

        if (titleConfigDto.getStatus() == 3) {
            return JsonResult.successResult("已归档记录，不允许操作");
        }

        if (remoteTitleConfigService.updateStatus(id, status)) {
            return JsonResult.successResult("Success");
        }
        return JsonResult.failedResult("保存失败");
    }

    public JsonResult<PagerResponse<TitleConfigVO>> page(PagerRequest pagerRequest, Integer type, Integer levelId, Integer status) {
        PagerResponse<TitleConfigDto> page = remoteTitleConfigService.page(pagerRequest, type, levelId, status);

        List<TitleConfigVO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(page.getRecords())) {
            for (TitleConfigDto configDto : page.getRecords()) {
                list.add(new TitleConfigVO(configDto));
            }
        }
        return JsonResult.successResult(new PagerResponse<>(page, list));
    }

    public JsonResult delete(int id) {
        TitleConfigDto titleConfigDto = remoteTitleConfigService.find(id);
        if (titleConfigDto == null) {
            return JsonResult.failedResult("数据不存在");
        }
        if (titleConfigDto.getStatus() == 1) {
            return JsonResult.failedResult("上线中的数据不能删除");
        }
        if (remoteTitleConfigService.delete(id)) {
            if (titleConfigDto.getStatus() == 2) {
                return JsonResult.successResult("归档成功");
            }
            return JsonResult.successResult("删除成功");
        }
        return JsonResult.failedResult("删除失败");
    }

    public JsonResult<TitleConfigVO> get(int id) {
        TitleConfigDto configDto = remoteTitleConfigService.find(id);
        if (configDto == null) {
            return JsonResult.successResult(null);
        }
        return JsonResult.successResult(new TitleConfigVO(configDto));
    }
}
