package cn.com.wawa.manager.biz.service;

import cn.com.wawa.manager.biz.bean.title.TitleLevelSaveBean;
import cn.com.wawa.manager.biz.vo.title.TitleConfigVO;
import cn.com.wawa.manager.biz.vo.title.TitleLevelIdNameVO;
import cn.com.wawa.manager.biz.vo.title.TitleLevelVO;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.title.TitleConfigDto;
import cn.com.wawa.service.api.dto.title.TitleLevelDto;
import cn.com.wawa.service.api.remoteservice.title.RemoteTitleLevelService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class TitleLevelService {

    @Resource
    private RemoteTitleLevelService remoteTitleLevelService;

    public JsonResult add(TitleLevelSaveBean titleLevelSaveBean) {
        TitleLevelDto titleLevelDto = new TitleLevelDto();
        BeanUtils.copyProperties(titleLevelSaveBean, titleLevelDto);
        if (titleLevelSaveBean.isChattingBroadcast()) {
            titleLevelDto.setChattingBroadcast(1);
        }
        if (titleLevelSaveBean.isRoomBroadcast()) {
            titleLevelDto.setRoomBroadcast(1);
        }

        if (remoteTitleLevelService.add(titleLevelDto)) {
            return JsonResult.successResult("Success");
        }
        return JsonResult.failedResult("保存失败");
    }

    public JsonResult update(TitleLevelSaveBean titleLevelSaveBean) {
        TitleLevelDto titleLevelDto = remoteTitleLevelService.find(titleLevelSaveBean.getId());
        if (titleLevelDto == null) {
            return JsonResult.failedResult("数据不存在");
        }

        BeanUtils.copyProperties(titleLevelSaveBean, titleLevelDto);
        if (titleLevelSaveBean.isChattingBroadcast()) {
            titleLevelDto.setChattingBroadcast(1);
        }
        if (titleLevelSaveBean.isRoomBroadcast()) {
            titleLevelDto.setRoomBroadcast(1);
        }

        if (remoteTitleLevelService.update(titleLevelDto)) {
            return JsonResult.successResult("Success");
        }
        return JsonResult.failedResult("保存失败");
    }

    public JsonResult delete(int id) {
        if (remoteTitleLevelService.delete(id)) {
            return JsonResult.successResult("删除成功");
        }
        return JsonResult.failedResult("删除失败");
    }

    public JsonResult<PagerResponse<TitleLevelVO>> page(PagerRequest pagerRequest, String name) {
        PagerResponse<TitleLevelDto> page = remoteTitleLevelService.page(pagerRequest, name);
        List<TitleLevelVO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(page.getRecords())) {
            for (TitleLevelDto levelDto : page.getRecords()) {
                list.add(new TitleLevelVO(levelDto));
            }
        }
        return JsonResult.successResult(new PagerResponse<>(page, list));
    }

    public JsonResult<List<TitleLevelIdNameVO>> list() {
        List<TitleLevelDto> list = remoteTitleLevelService.findAll();
        List<TitleLevelIdNameVO> resList = new ArrayList<>(list.size());
        for (TitleLevelDto dto : list) {
            TitleLevelIdNameVO idNameVO = new TitleLevelIdNameVO();
            idNameVO.setId(dto.getId());
            idNameVO.setName(dto.getName());
            resList.add(idNameVO);
        }
        return JsonResult.successResult(resList);
    }

    public JsonResult<TitleLevelVO> get(int id) {
        TitleLevelDto levelDto = remoteTitleLevelService.find(id);
        if (levelDto == null) {
            return JsonResult.successResult(null);
        }
        return JsonResult.successResult(new TitleLevelVO());
    }
}
