package cn.com.wawa.manager.biz.service;

import cn.com.wawa.manager.biz.tools.UploadTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;

@Service
public class UploadService {
    public static final Logger LOGGER = LoggerFactory.getLogger(UploadService.class);

    private static final String SEPARATOR = "/";

    public String doUpload(MultipartFile file, String contentType, String dir, String fileName) {
        String path;
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            path = "wawa/" + dir + SEPARATOR + fileName;
            boolean result = UploadTool.uploadOssStreamImg(inputStream, file.getSize(), path, contentType);
            if (result) {
                return path;
            }
        } catch (IOException e) {
            LOGGER.error("上传文件异常", e);
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    inputStream = null;
                    LOGGER.error("上传文件流关闭异常", e);
                }
            }
        }
        return null;
    }

}
