package cn.com.wawa.manager.biz.service;

import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.VersionDto;
import cn.com.wawa.service.api.remoteservice.VersionService;
import com.google.common.base.Splitter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service("versionDealService")
@Slf4j
public class VersionDealService {

    @Resource
    private VersionService versionService;

    public Boolean addVersionInfo(VersionDto versionDto){

        Boolean b=versionDto.getVersionName().matches("\\d{1,}.\\d{1,}.\\d{1,}");
        if (!b) {
            return false;
        }
        return versionDto.getId() != null && versionDto.getId() > 0 ? versionService.update(versionDto) : versionService.add(versionDto);
    }

    public Boolean updataVersionInfo(VersionDto versionDto){
        Boolean b=versionDto.getVersionName().matches("\\d{1,}.\\d{1,}.\\d{1,}");
        if (!b) {
            return false;
        }
        return versionService.update(versionDto);
    }

    public Boolean deleteVersionInfo(Long id) {
        return versionService.delete(id);
    }

    public Boolean updateStatus(Long id, Integer status){
        return versionService.updateStatus(id, status);
    }

    public PagerResponse<VersionDto> query(Integer pageIndex, Integer pageSize) {
        PagerRequest page = new PagerRequest();
        page.setPageIndex(pageIndex);
        page.setPageSize(pageSize);
        return versionService.query(page);
    }

    public void showTest(String userIds, Long id) {
        List<String> userIdList = Splitter.on(",").trimResults().splitToList(userIds);
        List<Long> collect = userIdList.stream().map(userId -> Long.parseLong(userId)).collect(Collectors.toList());
        versionService.showTest(collect, id);
    }

    public VersionDto queryById(Long id) {
        return versionService.queryById(id);
    }

    public Boolean isOnline(Integer clientType) {
        return versionService.isOnlineVersion(clientType);
    }
}
