package cn.com.wawa.manager.biz.service;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.wawa.manager.biz.bean.WawaCatcherSaveBean;
import cn.com.wawa.manager.biz.query.DecSaveQuery;
import cn.com.wawa.manager.biz.query.MonitorListQuery;
import cn.com.wawa.manager.biz.vo.*;
import cn.com.wawa.manager.common.enums.CatcherStatusEnums;
import cn.com.wawa.manager.common.enums.DecTypeEnums;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.WawaCatcherDto;
import cn.com.wawa.service.api.dto.WawaCatcherSaveDto;
import cn.com.wawa.service.api.dto.WawaCatcherSimpleDto;
import cn.com.wawa.service.api.dto.WawaEditDto;
import cn.com.wawa.service.api.enums.WawaCatcherHealthStatusEnum;
import cn.com.wawa.service.api.enums.WawaCatcherOperateEnum;
import cn.com.wawa.service.api.enums.WawaCatcherStatusEnum;
import cn.com.wawa.service.api.exception.BusinessException;
import cn.com.wawa.service.api.query.WawaCatcherQuery;
import cn.com.wawa.service.api.remoteservice.RemoteDingdingNotifyService;
import cn.com.wawa.service.api.remoteservice.RemoteWawaCatcherService;
import cn.com.wawa.service.api.remoteservice.RemoteWawaService;
import com.google.common.base.Preconditions;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * Created by gyf .
 * 2017/10/27 .
 */
@Service("wawaCatcherService")
public class WawaCatcherService {
    @Autowired
    private RemoteWawaCatcherService remoteWawaCatcherService;

    @Autowired
    private RemoteWawaService remoteWawaService;

    @Autowired
    private RemoteDingdingNotifyService remoteDingdingNotifyService;

    /**
     * 管理员后台,分页列表展示娃娃机
     *
     * @param pageIndex
     * @param pageSize
     * @return
     */
    public PagerResponse<WawaCatcherVO> page(Integer pageIndex, Integer pageSize, String query, Integer status, String wawaName,Integer playType) {
        PagerRequest pagerRequest = new PagerRequest(pageIndex, pageSize);

        PagerResponse<WawaCatcherDto> page = remoteWawaCatcherService.pageWithQuery(pagerRequest, query, status, wawaName,playType);
        List<WawaCatcherDto> dtos = page.getRecords();
        List<WawaCatcherVO> vos = new ArrayList<>();
        if(CollectionUtils.isEmpty(dtos)){
            return new PagerResponse<>();
        }
        WawaCatcherVO vo;
        for (WawaCatcherDto it : dtos) {
            vo = BeanUtils.copy(it, WawaCatcherVO.class);
            vo.setCatcherStatus(it.getCatcherStatus().value());
            vo.setHealthStatus(it.getHealthStatus().value());
            vos.add(vo);
        }
        return new PagerResponse<>(page, vos);
    }

    public WawaCatcherStatusCountVO countByStatus() {
        WawaCatcherStatusCountVO wawaCatcherStatusCountVO = new WawaCatcherStatusCountVO();

        wawaCatcherStatusCountVO.setEmpty(remoteWawaCatcherService.countByStatus(Long.valueOf(WawaCatcherStatusEnum.OFFSHELF.value()), 0L));
        wawaCatcherStatusCountVO.setOffShelf(remoteWawaCatcherService.countByStatus(Long.valueOf(WawaCatcherStatusEnum.OFFSHELF.value()), null));
        wawaCatcherStatusCountVO.setOnShelf(remoteWawaCatcherService.countByStatus(Long.valueOf(WawaCatcherStatusEnum.ONSHELF.value()), null));
        wawaCatcherStatusCountVO.setTotal(remoteWawaCatcherService.countByStatus(null, null));
        return wawaCatcherStatusCountVO;
    }

    /**
     * 控制是否显示娃娃机列表（显示升级维护中）
     * @param status 0：正常， 1：维护中
     * @return
     */
    public Boolean control(Integer status){
        return remoteWawaCatcherService.controlCatcher(status);
    }

    /**
     * 更新权重
     *
     * @param catcherId
     * @param payload
     * @return
     */
    public Boolean updatePayload(Long catcherId, Long payload) {
        Preconditions.checkNotNull(catcherId, "娃娃机id不能为null");
        Preconditions.checkNotNull(payload, "更新的排序值不能为null");
        return remoteWawaCatcherService.updatePayload(catcherId, payload);
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    public Boolean delete(Long id) {
        Preconditions.checkNotNull(id, "娃娃机id不能为null");
        return remoteWawaCatcherService.delete(id);
    }

    /**
     * 更新状态
     *
     * @param catcherId
     * @param operate
     * @return
     */
    public Boolean updateStatus(Long catcherId, Integer operate) {
        Preconditions.checkNotNull(catcherId, "娃娃机id不能为null");
        Preconditions.checkNotNull(operate, "操作不能为null");
        return remoteWawaCatcherService.updateStatus(catcherId, WawaCatcherOperateEnum.get(operate));
    }

    /**
     * 保存
     *
     * @param catcher
     * @return
     */
    public Boolean save(WawaCatcherSaveBean catcher) {
        WawaCatcherSaveDto dto = BeanUtils.copy(catcher, WawaCatcherSaveDto.class);
        return remoteWawaCatcherService.save(dto);
    }

    /**
     * 查询
     *
     * @param id
     * @return
     */
    public WawaCatcherEditVO find(Long id) {
        Preconditions.checkNotNull(id, "娃娃机不能为null");
        WawaCatcherSimpleDto wawaCatcher = remoteWawaCatcherService.find(id);
        return BeanUtils.copy(wawaCatcher, WawaCatcherEditVO.class);
    }

    public Boolean updateRemark(Long id, String mark) {
        Preconditions.checkNotNull(id, "娃娃机不能为null");
        return remoteWawaCatcherService.updateRemark(id, mark);
    }

    /**
     * 查询娃娃机监控列表
     */
    public PagerResponse<MonitorWawaCatcherVO> queryWawaMonitorList(MonitorListQuery monitorListQuery) {
        PagerRequest pagerRequest = new PagerRequest(monitorListQuery.getPageIndex(), monitorListQuery.getPageSize());
        WawaCatcherQuery query = new WawaCatcherQuery();
        if (StringUtils.isNotBlank(monitorListQuery.getCatcherName())) {
            query.setCatcherName(monitorListQuery.getCatcherName());
        }
        PagerResponse<WawaCatcherDto> pagerResponse = remoteWawaCatcherService.findCatcherDescByStock(pagerRequest, query);
        if (CollectionUtils.isEmpty(pagerResponse.getRecords()))
            return new PagerResponse(pagerRequest, 0, new ArrayList());
        List<WawaCatcherDto> record = sortDto(pagerResponse.getRecords());
        pagerResponse.setRecords(record);
        //构建返回vo
        return this.buildMonitorVO(pagerResponse);
    }

    private List<WawaCatcherDto> sortDto(List<WawaCatcherDto> records) {
        LinkedList<WawaCatcherDto> stockMore5 = new LinkedList<>();
        Iterator<WawaCatcherDto> iterator = records.iterator();
        while (iterator.hasNext()) {
            WawaCatcherDto catcher = iterator.next();
            if (catcher.getRow() != 0 && catcher.getStock() > 5) {
                stockMore5.add(catcher);
                iterator.remove();
            }
        }
        sortGroupByRow(records);
        sortGroupByRow(stockMore5);
        for (WawaCatcherDto wawaCatcherDto : stockMore5) {
            records.add(wawaCatcherDto);
        }
        return records;
    }

    private void sortGroupByRow(List<WawaCatcherDto> records) {
        Collections.sort(records, new Comparator<WawaCatcherDto>() {
            @Override
            public int compare(WawaCatcherDto o1, WawaCatcherDto o2) {
                if(o1 != null && o2!= null && o1.getRow() != null && o2.getRow() != null){
                    if (o1.getRow() > o2.getRow()) {
                        return 1;
                    }else if(o1.getRow() < o2.getRow()){
                        return -1;
                    }
                }
                return 0;
            }
        });
    }

    /**
     * 查询监控娃娃机详情
     *
     * @param catcherId
     * @return
     */
    public MonitorWawaChangeVO queryMonitorDetail(Long catcherId) {

        List<WawaCatcherDto> healCatchers = findCatcherByQuery();
        WawaCatcherDto catcherDto = null;
        String catcherIdStr = String.valueOf(catcherId);
        for (WawaCatcherDto wawaCatcherDto : healCatchers) {
            if (String.valueOf(wawaCatcherDto.getId()).equals(catcherIdStr))
                catcherDto = wawaCatcherDto;
        }
        if (null == catcherDto)
            throw new BusinessException("该娃娃机处于异常状态，请通过后台处理");
        Long wawaId = catcherDto.getWawaId();
        //查询娃娃
        WawaEditDto wawaEditDto = remoteWawaService.find(wawaId);
        //构建
        MonitorWawaChangeVO resultBase = new MonitorWawaChangeVO();
        resultBase.setWawaName(wawaEditDto.getWawaName());
        resultBase.setCatcherId(catcherDto.getId());
        resultBase.setCatcherName(catcherDto.getCatcherName());
        resultBase.setStock(catcherDto.getStock());
        resultBase.setTotality(catcherDto.getTotality());
        resultBase.setCatcherStatus(catcherDto.getStock() > 1 ?
                catcherDto.getCatcherStatus().desc() : CatcherStatusEnums.get(catcherDto.getCatcherStatus().value()).getDesc());

        Long repairNum = filterRepairNum(healCatchers);

        resultBase.setRepairNum(Integer.valueOf(String.valueOf(repairNum)));
        return resultBase;
    }

    private List<WawaCatcherDto> findCatcherByQuery() {
        WawaCatcherQuery query = new WawaCatcherQuery();
        query.setHealthStatus(WawaCatcherHealthStatusEnum.HEALTH.value());
        List<WawaCatcherDto> healCatchers = remoteWawaCatcherService.findCatcherByQuery(query);
        if (CollectionUtils.isEmpty(healCatchers)) {
            throw new BusinessException("该娃娃机处于异常状态，请通过后台处理");
        }
        return healCatchers;
    }

    private Long filterRepairNum(List<WawaCatcherDto> healCatchers) {
        //查询待补充状态娃娃机,查询出所有健康的,再做筛选
        List<WawaCatcherDto> repairCatchers = healCatchers.stream().filter(f -> f.getWawaId() > 0).collect(Collectors.toList());
        Long repairNum = repairCatchers.stream().filter(e ->
                e.getCatcherStatus() == WawaCatcherStatusEnum.OFFSHELF && e.getStock() <= 1
                        || e.getCatcherStatus() == WawaCatcherStatusEnum.ONSHELF
                        && e.getStock() <= 1
        ).count();
        return repairNum;
    }

    private PagerResponse<MonitorWawaCatcherVO> buildMonitorVO(PagerResponse<WawaCatcherDto> pagerResponse) {
        List<WawaCatcherDto> wawaCatcherDtos = pagerResponse.getRecords();
        List<WawaCatcherDto> healCatchers = findCatcherByQuery();
        Long repairNum = filterRepairNum(healCatchers);
        //查询上线娃娃机数量
        int onshelfNum = remoteWawaCatcherService.countByStatus(Long.valueOf(WawaCatcherStatusEnum.ONSHELF.value()), null);
        List<MonitorWawaCatcherVO> monitorCatcherVOs = wawaCatcherDtos.stream().map(catcher -> {
            MonitorWawaCatcherVO monitorCatcher = new MonitorWawaCatcherVO();
            monitorCatcher.setCatcherId(catcher.getId());
            monitorCatcher.setCatcherName(catcher.getCatcherName());
            monitorCatcher.setStock(catcher.getStock());
            monitorCatcher.setTotality(catcher.getTotality());
            monitorCatcher.setCatcherStatus(catcher.getStock() > 1 ?
                    catcher.getCatcherStatus().desc() : CatcherStatusEnums.get(catcher.getCatcherStatus().value()).getDesc());
            monitorCatcher.setOnlineCatcherNum(onshelfNum);
            monitorCatcher.setRepairNum(Integer.valueOf(String.valueOf(repairNum)));
            return monitorCatcher;
        }).collect(Collectors.toList());
        //排序
        this.monitorSort(monitorCatcherVOs);
        return new PagerResponse<>(pagerResponse, monitorCatcherVOs);
    }

    public Boolean monitorAlarm(DecSaveQuery decSaveQuery) {
        //查询出娃娃机
        WawaCatcherSimpleDto catcherSimpleDto = remoteWawaCatcherService.find(decSaveQuery.getCatcherId());
        if (null == catcherSimpleDto)
            throw new BusinessException("娃娃机不存在");
        Integer stock = catcherSimpleDto.getStock();
        String catcherName = catcherSimpleDto.getCatcherName();
        String sendContext = null;
        switch (DecTypeEnums.get(Integer.valueOf(decSaveQuery.getDecType()))) {
            case WAWA_NUM:
                sendContext = String.format(DecTypeEnums.WAWA_NUM.getMsg(), catcherName, decSaveQuery.getDecContent(), stock);
                break;
            case ORDER_PROBLEM:
                sendContext = String.format(DecTypeEnums.ORDER_PROBLEM.getMsg(), catcherName, decSaveQuery.getDecContent());
                break;
            default:
                break;
        }
        if (StringUtils.isBlank(sendContext))
            throw new BusinessException("告警类型配置有误");
        //发送告警
        return remoteDingdingNotifyService.notifyByDefault(sendContext);
    }

    public Boolean supSuccess(Long catcherId) {
        //查询出娃娃机
        WawaCatcherQuery query = new WawaCatcherQuery();
        query.setCatcherId(catcherId);
        List<WawaCatcherDto> wawaCatcherDtos = remoteWawaCatcherService.findCatcherByQuery(query);
        if (CollectionUtils.isEmpty(wawaCatcherDtos))
            throw new BusinessException("娃娃机不存在");
        WawaCatcherDto wawaCatcherDto = wawaCatcherDtos.get(0);
        if (wawaCatcherDto.getHealthStatus() == WawaCatcherHealthStatusEnum.NOT_HEALTH)
            throw new BusinessException("娃娃机已经下线");
        WawaCatcherDto resultBase = new WawaCatcherDto();
        resultBase.setId(catcherId);
        resultBase.setCatcherStatus(wawaCatcherDto.getCatcherStatus() == WawaCatcherStatusEnum.ONTEST ? WawaCatcherStatusEnum.ONTEST : WawaCatcherStatusEnum.ONSHELF);
        resultBase.setHealthStatus(WawaCatcherHealthStatusEnum.HEALTH);
        resultBase.setStock(wawaCatcherDto.getTotality());
        resultBase.setLastPolishTime(new Date());
        return remoteWawaCatcherService.update(resultBase);
    }

    private void monitorSort(List<MonitorWawaCatcherVO> monitorCatcherVOs) {
        if (CollectionUtils.isEmpty(monitorCatcherVOs))
            return;
        List<MonitorWawaCatcherVO> fullMonitor = monitorCatcherVOs.parallelStream()//过滤出补齐的,并且按照库存排序
                .filter(monitor -> String.valueOf(monitor.getStock()).equals(String.valueOf(monitor.getTotality())))
                .sorted(Comparator.comparing(MonitorWawaCatcherVO::getStock)).collect(Collectors.toList());
        monitorCatcherVOs.removeAll(fullMonitor);
        monitorCatcherVOs.addAll(fullMonitor);
    }


    public PagerResponse<MonitorWawaCatcherVO> getAllCatcher(MonitorListQuery monitorListQuery) {
        PagerRequest pagerRequest = new PagerRequest(monitorListQuery.getPageIndex(), monitorListQuery.getPageSize());
        WawaCatcherQuery query = new WawaCatcherQuery();
        if (StringUtils.isNotBlank(monitorListQuery.getCatcherName())) {
            query.setCatcherName(monitorListQuery.getCatcherName());
        }
        PagerResponse<WawaCatcherDto> pagerResponse = remoteWawaCatcherService.findAllCatcherByPage(pagerRequest, query);
        return buildMonitorVO(pagerResponse);
    }


}
