package cn.com.wawa.manager.biz.service;

import cn.com.wawa.manager.biz.bean.WawaCategorySaveBean;
import cn.com.wawa.manager.biz.bean.WawaPayloadBean;
import cn.com.wawa.manager.biz.tools.LocalDateUtil;
import cn.com.wawa.manager.biz.vo.WawaCategoryListVO;
import cn.com.wawa.manager.biz.vo.WawaCategoryVO;
import cn.com.wawa.manager.biz.vo.WawaVO;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.dto.WawaCategoryDto;
import cn.com.wawa.service.api.dto.WawaCategoryListDto;
import cn.com.wawa.service.api.dto.WawaDto;
import cn.com.wawa.service.api.remoteservice.RemoteWawaCategoryService;
import cn.com.wawa.service.api.remoteservice.RemoteWawaService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class WawaCategoryService {

    @Resource
    private RemoteWawaCategoryService remoteWawaCategoryService;

    @Resource
    private RemoteWawaService remoteWawaService;

    public JsonResult save(WawaCategorySaveBean wawaCategorySaveBean) {
        WawaCategoryDto wawaCategoryDto = new WawaCategoryDto();
        wawaCategoryDto.setOnlineTime(LocalDateUtil.getFullDate(wawaCategorySaveBean.getOnlineTimeStr()));
        wawaCategoryDto.setOfflineTime(LocalDateUtil.getFullDate(wawaCategorySaveBean.getOfflineTimeStr()));
        wawaCategoryDto.setCategoryName(wawaCategorySaveBean.getCategoryName());
        if (!CollectionUtils.isEmpty(wawaCategorySaveBean.getWawaIds())) {
            wawaCategoryDto.setWawaIds(wawaCategorySaveBean.getWawaIds().stream().map(WawaPayloadBean::getId).collect(Collectors.toList()));
        }
        wawaCategoryDto.setId(wawaCategorySaveBean.getId());

        WawaCategoryDto dto = remoteWawaCategoryService.findByName(wawaCategorySaveBean.getCategoryName());

        if (wawaCategorySaveBean.getId() < 1) {
            if (dto != null) {
                return JsonResult.failedResult("该类目已经存在");
            }
            if (remoteWawaCategoryService.insert(wawaCategoryDto)) {
                return JsonResult.successResult("Success");
            }
        }

        if (dto != null && dto.getId() != wawaCategorySaveBean.getId()) {
            return JsonResult.failedResult("该类目已经存在");
        }

        if (remoteWawaCategoryService.update(wawaCategoryDto)) {
            return JsonResult.successResult("Success");
        }

        return JsonResult.failedResult("保存失败");
    }

    public JsonResult updateState(long id, int state) {
        WawaCategoryDto dto = remoteWawaCategoryService.find(id);
        if (dto == null) {
            return JsonResult.failedResult("数据不存在");
        }

        if (state == 1) {
            int count = remoteWawaCategoryService.countByState(1);
            if (count >= 10) {
                return JsonResult.failedResult("类目不得超过10个");
            }
        }

        if (remoteWawaCategoryService.updateState(id, state)) {
            return JsonResult.successResult("Success");
        }
        return JsonResult.failedResult("保存失败");
    }

    public JsonResult<WawaCategoryListVO> list(Integer state) {
        WawaCategoryListVO wawaCategoryListVO = new WawaCategoryListVO();
        List<WawaCategoryVO> wawaCategoryVOS = new ArrayList<>();

        WawaCategoryListDto wawaCategoryListDto = remoteWawaCategoryService.listByState(state);
        wawaCategoryListVO.setOnlineNum(wawaCategoryListDto.getOnlineNum());
        wawaCategoryListVO.setTotal(wawaCategoryListDto.getTotal());
        List<WawaCategoryDto> wawaCategoryDtoList = wawaCategoryListDto.getWawaCategoryDtoList();

        if (!CollectionUtils.isEmpty(wawaCategoryDtoList)) {
            for (WawaCategoryDto dto : wawaCategoryDtoList) {
                WawaCategoryVO wawaCategoryVO = new WawaCategoryVO(dto);
                wawaCategoryVOS.add(wawaCategoryVO);
            }
        }

        wawaCategoryListVO.setList(wawaCategoryVOS);

        return JsonResult.successResult(wawaCategoryListVO);
    }

    public JsonResult delete(long id) {
        WawaCategoryDto dto = remoteWawaCategoryService.find(id);
        if (dto == null) {
            return JsonResult.failedResult("数据不存在");
        }
        if (dto.getState() == 1) {
            return JsonResult.failedResult("上线中的数据不能删除");
        }
        if (remoteWawaCategoryService.delete(id)) {
            return JsonResult.successResult("删除成功");
        }
        return JsonResult.failedResult("删除失败");
    }

    public JsonResult<WawaCategoryVO> get(long id) {
        WawaCategoryDto dto = remoteWawaCategoryService.find(id);
        if (dto == null) {
            return JsonResult.successResult(null);
        }

        List<WawaDto> list = remoteWawaService.findByCategoryId(id);
        List<WawaVO> wawaList = new ArrayList<>();
        for (WawaDto wawaDto : list) {
            WawaVO wawaVO = new WawaVO();
            BeanUtils.copyProperties(wawaDto, wawaVO);
            wawaList.add(wawaVO);
        }

        WawaCategoryVO wawaCategoryVO = new WawaCategoryVO(dto);
        wawaCategoryVO.setWawaVOList(wawaList);

        return JsonResult.successResult(wawaCategoryVO);
    }

    public JsonResult<WawaCategoryListVO> listOnline() {
        WawaCategoryListVO wawaCategoryListVO = new WawaCategoryListVO();
        List<WawaCategoryVO> wawaCategoryVOS = new ArrayList<>();

        WawaCategoryListDto wawaCategoryListDto = remoteWawaCategoryService.listByState(1);
        List<WawaCategoryDto> wawaCategoryDtoList = wawaCategoryListDto.getWawaCategoryDtoList();
        if (!CollectionUtils.isEmpty(wawaCategoryDtoList)) {
            for (WawaCategoryDto dto : wawaCategoryDtoList) {
                WawaCategoryVO wawaCategoryVO = new WawaCategoryVO(dto);
                wawaCategoryVOS.add(wawaCategoryVO);
            }
        }

        wawaCategoryListVO.setList(wawaCategoryVOS);

        return JsonResult.successResult(wawaCategoryListVO);
    }

    public JsonResult updateRank(long id, int rank) {
        WawaCategoryDto dto = remoteWawaCategoryService.find(id);
        if (dto == null) {
            return JsonResult.failedResult("数据不存在");
        }

        if (remoteWawaCategoryService.updateRank(id, rank)) {
            return JsonResult.successResult("Success");
        }
        return JsonResult.failedResult("保存失败");
    }
}
