package cn.com.wawa.manager.biz.service;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.wawa.manager.biz.bean.wawa.PurchaseStateUpdateBean;
import cn.com.wawa.manager.biz.vo.WawaSelectedVO;
import cn.com.wawa.manager.biz.vo.WawaTypeVo;
import cn.com.wawa.manager.biz.vo.WawaVO;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.*;
import cn.com.wawa.service.api.remoteservice.RemoteWawaService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by gyf .
 * 2017/10/27 .
 */
@Service("wawaService")
public class WawaService {
    public static final Logger log = LoggerFactory.getLogger(WawaService.class);

    @Autowired
    private RemoteWawaService remoteWawaService;

    /**
     * 获取待选娃娃列表
     * @return
     */
    public List<WawaSelectedVO> getWawas() {
        List<WawaSelectedDto> wawas = remoteWawaService.findSelectedList();
        List<WawaSelectedVO> wawaVos = new ArrayList<>(wawas.size());
        WawaSelectedVO vo;
        for (WawaSelectedDto it : wawas) {
            vo = new WawaSelectedVO();
            vo.setWawaId(it.getId());
            vo.setWawaName(it.getWawaName());
            vo.setPrice(it.getPrice());
            wawaVos.add(vo);
        }
        return wawaVos;
    }

    /**
     * 查询分页列表
     * @param pageIndex
     * @param pageSize
     * @return
     */
    public PagerResponse<WawaVO> page(Integer pageIndex, Integer pageSize, String wawaName, Integer state,Integer supportExchange, Long categoryId) {
        PagerRequest pagerRequest = new PagerRequest(pageIndex, pageSize);
        PagerResponse<WawaDto> page = remoteWawaService.page(pagerRequest, wawaName, state,supportExchange, categoryId);
        List<WawaDto> dtos = page.getRecords();
        return new PagerResponse<>(page, BeanUtils.copyList(dtos, WawaVO.class));
    }

    /**
     * 更新权重
     * @param id
     * @param payload
     * @return
     */
    public boolean updatePayload(Long id ,Long payload){
        return remoteWawaService.updatePayload(id,payload);
    }

    /**
     * 删除
     * @param id
     * @return
     */
    public JsonResult delete(Long id) {
        Preconditions.checkNotNull(id, "id不能为null");
        return remoteWawaService.delete(id);
    }

    /**
     * 保存
     * @param dto
     * @return
     */
    public Boolean save(WawaSaveDto dto) {
        return remoteWawaService.save(dto);
    }

    /**
     * 查询单个
     * @param id
     * @return
     */
    public WawaEditDto find(Long id) {
        Preconditions.checkNotNull(id, "id不能为null");
        return remoteWawaService.find(id);
    }

    public List<WawaTypeVo> findWawaTypes (){
        List<WawaTypeDto> wawaTypes = remoteWawaService.getWawaTypes();
        return BeanUtils.copyList(wawaTypes, WawaTypeVo.class);
    }

    /**
     * 查询归档分页列表
     * @param pageIndex
     * @param pageSize
     * @return
     */
    public PagerResponse<WawaVO> recyclePage(Integer pageIndex, Integer pageSize, String wawaName) {
        PagerRequest pagerRequest = new PagerRequest(pageIndex, pageSize);
        PagerResponse<WawaDto> page = remoteWawaService.recyclePage(pagerRequest, wawaName);
        if (page == null) {
            return new PagerResponse<>(pagerRequest, 0, null);
        }
        List<WawaDto> dtos = page.getRecords();
        return new PagerResponse<>(page, BeanUtils.copyList(dtos, WawaVO.class));
    }

    public JsonResult recycle(Long id) {
        return remoteWawaService.recycle(id);
    }

    public Boolean recovery(Long id) {
        return remoteWawaService.recovery(id);
    }

    public BigDecimal getRate(Long price, Long primeCost, Long returnAwardRate) {
        return remoteWawaService.getCaughtRate(price, primeCost, returnAwardRate);
    }

    public JsonResult updatePurchaseState(PurchaseStateUpdateBean updateBean) {
        WawaEditDto dto = remoteWawaService.find(updateBean.getId());
        if (dto == null) {
            return JsonResult.failedResult("数据不存在");
        }
        if (remoteWawaService.updatePurchaseState(updateBean.getId(), updateBean.getPurchaseState())) {
            return JsonResult.successResult(null);
        }
        return JsonResult.failedResult("更新失败");
    }

    /**
     * 设置娃娃是否为vip专享 1:为vip专享，0:不为vip专享
     * @param id
     * @param vipCategoryFlag
     * @return
     */
    public Boolean setVipCategoryFlag(Long id,Integer vipCategoryFlag){
        return remoteWawaService.setVipCategoryFlag(id,vipCategoryFlag);
    }
}
