package cn.com.wawa.manager.biz.tools;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 功能描述:image type判断
 */
@Component
public class ImageUtils {

    @Value("${wawa.resource.host}")
    private String host;

    private static final String IMAGE_TYPE = "image/png,image/gif,image/jpg,image/jpeg,image/pjpeg";

    /**
     * 判断是否是需要的图片类型
     *
     * @param contentType 图片类型
     * @return
     */
    public boolean isRequireImageType(String contentType) {
        if (contentType == null || "".equals(contentType)) {
            return false;
        }
        return IMAGE_TYPE.contains(contentType);
    }

    /**
     * getHttpUrl
     *
     * @param path
     * @return
     */
    public String getUrl(String path) {
        if (EnvironmentUtil.isDev() || EnvironmentUtil.isTest()) {
            return "//yun.dui88.com/" + path;
        }
        return "//" + host + "/" + path;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}
