package cn.com.wawa.manager.biz.tools;
import cn.com.wawa.manager.biz.tools.cdn.OpenapiClient;
import cn.com.wawa.service.api.exception.BusinessException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.cdn.model.v20141111.RefreshObjectCachesRequest;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

/**
 * 功能描述:
 */
@Component
public class UploadTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadTool.class);

    private static String ACCESSID;

    private static String ACCESSKEY;

    private static String ENDPOINT;

    private static String BUCKETNAME;

    private static String SERVERURL;

    private static String OBJECTPATH;

	/**
     * 上传流OssImg文件
     * @param imageStream
     * @param size
     * @param objectName
     * @param contentType
     * @return
     */
    public static boolean uploadOssStreamImg(InputStream imageStream, long size, String objectName, String contentType) {
        return uploadStreamOss(imageStream, size, objectName, contentType, null);
    }

    /**
     * 直接流上传
     * @param imageStream
     * @param size
     * @param objectName
     * @param contentType
     * @return
     */
    public static boolean uploadOssStream(InputStream imageStream, long size, String objectName, String contentType) {
        return uploadStreamOss(imageStream, size, objectName, contentType, null);
    }

	/**
     * 上传OssImg文件
     * @param file
     * @param objectName
     * @param contentType
     * @return
     */
    public static boolean uploadOssImg(File file, String objectName, String contentType) {
        return uploadOss(file, objectName, contentType);
    }

    /**
     * 上传OssCss文件
     *
     * @param file
     * @param objectName  oss上的文件目录
     * @return
     */
    public static boolean uploadOssCss(File file,String objectName){
        return uploadOss(file,objectName,"text/css");
    }

    /**
     * 上传OssJs文件
     *
     * @param file
     * @param objectName oss上的文件目录
     * @return
     */
    public static boolean uploadOssJs(File file,String objectName){
        return uploadOss(file,objectName,"text/js");
    }

    /**
     * 上传OssHtml模板文件
     *
     * @param file
     * @param objectName oss上的文件目录
     * @return
     */
    public static boolean uploadOssHtml(File file,String objectName){
        return uploadOss(file,objectName,"text/html");
    }

	/**
     * uploadOss
     * @param file
     * @param objectName
     * @return
     */
    public static boolean uploadOss(File file, String objectName) {
        return uploadOss(file, objectName, null);
    }

	/**
     * uploadOss
     * @param file
     * @param objectName
     * @param contentType
     * @return
     */
    public static boolean uploadOss(File file, String objectName, String contentType) {
        return uploadOss(file, objectName, contentType, null);
    }

    /**
     * 流上传oss
     *
     * @param fileStream       文件流
     * @param size             文件大小
     * @param objectName
     * @param contentType      文件类型
     * @param targetBucketName
     * @return
     */
    private static boolean uploadStreamOss(InputStream fileStream, long size, String objectName, String contentType, String targetBucketName) {
        OSSClient clientOss = new OSSClient(ENDPOINT, ACCESSID, ACCESSKEY);
        // 获取Bucket的存在信息
        boolean resultFlag = false;
        String bktName;
        if (EnvironmentUtil.isTest() || EnvironmentUtil.isDev()) {
            bktName = "daily-duiba";
        }else if(StringUtils.isNotBlank(targetBucketName)){
            bktName = targetBucketName;
        }else {
            bktName = BUCKETNAME;
        }

        if (clientOss.doesBucketExist(bktName)) {
            try {
                // 创建上传Object的Metadata
                ObjectMetadata meta = new ObjectMetadata();
                // 必须设置ContentLength
                meta.setContentLength(size);
                if (!StringUtils.isEmpty(contentType)) {
                    meta.setContentType(contentType);
                }
                boolean flag = false;
                if (isFileExist(objectName, bktName, clientOss)) {
                    flag = true;
                }
                // 上传Object.
                clientOss.putObject(bktName, objectName, fileStream, meta);
                if (flag) {
                    refreshObjectCaches(objectName);
                }
                resultFlag = true;
            } catch (ClientException e) {
                LOGGER.error(e.getMessage(), e);
                resultFlag = false;
            }
        }

        return resultFlag;

    }

	/**
     * CDN刷新缓存
     * @param path
     * @return
     */
//    public static boolean refreshObjectCaches(String path) {
//        AliyunClient clientCdn = new DefaultAliyunClient(SERVERURL, ACCESSID, ACCESSKEY);
//        RefreshObjectCachesRequest request = new RefreshObjectCachesRequest();
//        request.setObjectType(ObjectType.File.name());
//        request.setObjectPath(OBJECTPATH + path);
//        boolean resultFlag = false;
//        try {
//            RefreshObjectCachesResponse response = clientCdn.execute(request);
//            if (StringUtils.isEmpty(response.getErrorCode())) {
//                resultFlag = true;
//            } else {
//                //刷新失败
//                resultFlag = false;
//                LOGGER.error("message:" + response.getMessage());
//            }
//        } catch (ApiException e) {
//            LOGGER.error(e.getMessage(), e);
//            resultFlag = false;
//        }
//        return resultFlag;
//
//    }

    /**
     * CDN刷新缓存
     * @param path
     */
    public static void refreshObjectCaches(String path) {
        refreshOpenApiCaches(OBJECTPATH+path);

        IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", ACCESSID,ACCESSKEY);
        DefaultAcsClient client = new DefaultAcsClient(profile);

        RefreshObjectCachesRequest request = new RefreshObjectCachesRequest();
        request.setObjectType(ObjectType.File.name());
        request.setObjectPath(OBJECTPATH + path);
        try {
            HttpResponse response= client.doAction(request);
            if(!response.isSuccess()){
                throw new BusinessException(new String(response.getHttpContent()));
            }
        } catch (Exception e) {
            LOGGER.error("上传CDN刷新缓存出错:path:{},OBJECTPATH:{}",path,OBJECTPATH, e);
        }
    }

    private static void refreshOpenApiCaches(String path) {
        OpenapiClient.send(path);
    }

    /**
     * 检查文件是否存在
     * @param fileName
     * @return
     */
    public static boolean checkfile(String fileName){
        return isFileExist(fileName, null, null);
    }

    /**
     * 验证文件是否存在
     *
     * @param objectName
     * @return
     */
    private static boolean isFileExist(String objectName, String targetBucketName, OSSClient clientOss) {
        OSSClient ossClient = clientOss;
        if (clientOss == null) {
            ossClient = new OSSClient(ENDPOINT, ACCESSID, ACCESSKEY);
        }
        try {
            String bktName = targetBucketName;
            if (EnvironmentUtil.isTest() || EnvironmentUtil.isDev()) {
                bktName = "daily-duiba";
            }else if(StringUtils.isBlank(targetBucketName)){
                bktName = BUCKETNAME;
            }
            ossClient.getObjectMetadata(bktName, objectName);
            return true;
        } catch (ClientException e) {
            LOGGER.error(e.getMessage(), e);
            return false;
        } catch (OSSException e) {
            if (!"NoSuchKey".equals(e.getErrorCode())) {
                LOGGER.error(e.getMessage(), e);
            }
            return false;
        }
    }

    /**
     * 上传Oss文件
     *
     * @param file
     * @param objectName
     * @return
     */
    private static boolean uploadOss(File file, String objectName, String contentType, String targetBucketName) {
        OSSClient clientOss = new OSSClient(ENDPOINT, ACCESSID, ACCESSKEY);
        // 获取Bucket的存在信息
        boolean resultFlag = false;

        String bktName = targetBucketName;
        if (EnvironmentUtil.isTest() || EnvironmentUtil.isDev()) {
            bktName = "daily-duiba";
        }else if (StringUtils.isBlank(targetBucketName)) {
            bktName = BUCKETNAME;
        }

        if (clientOss.doesBucketExist(bktName)) {
            try(InputStream content = new FileInputStream(file)) {

                // 创建上传Object的Metadata
                ObjectMetadata meta = new ObjectMetadata();
                // 必须设置ContentLength
                meta.setContentLength(file.length());
                if (!StringUtils.isEmpty(contentType)) {
                    meta.setContentType(contentType);
                }
                boolean flag = false;
                if (isFileExist(objectName, bktName, clientOss)) {
                    flag = true;
                }
                // 上传Object.
                clientOss.putObject(bktName, objectName, content, meta);
                if (flag) {
                    refreshObjectCaches(objectName);
                }
                resultFlag = true;
            } catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
                resultFlag = false;
            }
        }
        return resultFlag;

    }

    /**
     * 刷新路径类型
     */
    enum ObjectType {
        /* 文件 */
        File,
        /* 目录 */
        Directory;
    }

    @Value("${wawa.oss.accessId}")
    public void setAccessId(String accessId) {
        ACCESSID = accessId;
    }

    @Value("${wawa.oss.accessKey}")
    public void setAccessKey(String accessKey) {
        ACCESSKEY = accessKey;
    }

    @Value("${wawa.oss.endPoint}")
    public void setEndPoint(String endPoint) {
        ENDPOINT = endPoint;
    }

    @Value("${wawa.oss.bucketName}")
    public void setBucketName(String bucketName) {
        BUCKETNAME = bucketName;
    }

    @Value("${wawa.oss.serverUrl}")
    public void setServerUrl(String serverUrl) {
        SERVERURL = serverUrl;
    }

    @Value("${wawa.oss.objectPath}")
    public void setObjectPath(String objectPath) {
        OBJECTPATH = objectPath;
    }
}
