package cn.com.wawa.manager.biz.tools.cdn;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.TreeMap;

@Component
public class OpenapiClient {

    private static final Logger LOGGER = LoggerFactory.getLogger(OpenapiClient.class);

    private static String serverUrl;
    private static String accessKeyId;
    private static String accessKeySecret;

    private static String url = "/v2/index.php";
    private static String requestMethod = "GET";
    private static String action = "RefreshCdnUrl";

    public static void send(String path) {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put("urls.0", path);
        action = ucFirst(action);
        params.put("Action", action);
        try {
            String response = OpenapiTool.send(params, accessKeyId, accessKeySecret, requestMethod, serverUrl, url, null);
            String urls = OpenapiTool.generateUrl(params, accessKeyId, accessKeySecret, requestMethod, serverUrl, url);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    private static String ucFirst(String word) {
        return word.replaceFirst(word.substring(0, 1), word.substring(0, 1).toUpperCase());
    }

    @Value("${app.openapi.serverUrl}")
    public void setAccessId(String accessId) {
        serverUrl = accessId;
    }

    @Value("${app.openapi.accessId}")
    public void setAccessKey(String accessKey) {
        accessKeyId = accessKey;
    }

    @Value("${app.openapi.accessKey}")
    public void setEndPoint(String endPoint) {
        accessKeySecret = endPoint;
    }
}
