package cn.com.wawa.manager.biz.vo;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.service.api.dto.AdConfigDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("广告信息")
public class AdConfigVO {
    @ApiModelProperty("主键id")
    private Long id;
    @ApiModelProperty("广告名称")
    private String adName;
    @ApiModelProperty("类目ID")
    private Long categoryId;
    @ApiModelProperty("图片地址")
    private String image;
    @ApiModelProperty("跳转链接")
    private String url;
    @ApiModelProperty("排序")
    private Integer payload;
    @ApiModelProperty("广告状态（1：上线 2：下线）")
    private Integer adStatus;
    @ApiModelProperty("上线时间")
    private String openTime;
    @ApiModelProperty("下线时间")
    private String closeTime;
    @ApiModelProperty("最小版本")
    private Integer minVersionCode;
    @ApiModelProperty("最大版本")
    private Integer maxVersionCode;
    @ApiModelProperty("客户端类型 0：全部  1：IOS 2：ANDROID")
    private Integer clientType;
    @ApiModelProperty("创建时间")
    private String gmtCreate;
    @ApiModelProperty("修改时间")
    private String gmtModified;


    public AdConfigVO() {
    }

    public AdConfigVO(AdConfigDto adConfigDto) {
        BeanUtils.copy(adConfigDto, this);
        if (adConfigDto.getOpenTime() != null) {
            this.openTime = DateUtils.getSecondStr(adConfigDto.getOpenTime());
        }
        if (adConfigDto.getCloseTime() != null) {
            this.closeTime = DateUtils.getSecondStr(adConfigDto.getCloseTime());
        }
        this.gmtCreate = DateUtils.getSecondStr(adConfigDto.getGmtCreate());
        this.gmtModified = DateUtils.getSecondStr(adConfigDto.getGmtModified());
    }

}
