package cn.com.wawa.manager.biz.vo;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.manager.common.constants.BizConstants;
import cn.com.wawa.service.api.dto.AppealDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel("申诉详情")
@Data
public class AppealVO {
    @ApiModelProperty("申诉表id")
    private Long id;
    @ApiModelProperty("处理状态  1：已处理 0 未处理")
    private Integer handleStatus;
    @ApiModelProperty("申诉原因")
    private String appealReason;
    @ApiModelProperty("驳回原因")
    private String rejectReason;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("结果状态  1：已退币 2 判为抓中 3驳回")
    private Integer resultStatus;
    @ApiModelProperty("操作人")
    private String operatorName;
    @ApiModelProperty("申诉时间")
    private String gmtCreate;
    @ApiModelProperty("处理时间")
    private String gmtModified;
    @ApiModelProperty("用户头像")
    private String localAvatar;
    @ApiModelProperty("用户昵称")
    private String nickName;
    @ApiModelProperty("抓抓号")
    private Long catchId;
    @ApiModelProperty("娃娃ID")
    private Long wawaId;
    @ApiModelProperty("娃娃名称")
    private String wawaName;
    @ApiModelProperty("娃娃机(房间)名称")
    private String catcherName;
    @ApiModelProperty("娃娃机(房间)id")
    private Long catcherId;
    @ApiModelProperty("视频地址")
    private String videoUrl;

    @ApiModelProperty("处理结果")
    private String result;
    @ApiModelProperty("抓取结果 1 抓中 其他是未抓中")
    private Integer isCatched;
    @ApiModelProperty("抓取时间")
    private String orderGmtCreate;
    @ApiModelProperty("本次记录花费")
    private Long price;
    @ApiModelProperty("true 驳回,false 通过")
    private Boolean isReject;


    @ApiModelProperty("vip等级")
    private Integer vipLevel;

    public AppealVO() {
    }

    public AppealVO(AppealDto appealDto) {
        this.id = appealDto.getId();
        this.handleStatus = appealDto.getHandleStatus();
        this.appealReason = appealDto.getAppealReason();
        this.rejectReason = appealDto.getRejectReason();
        this.remark = appealDto.getRemark();
        this.resultStatus = appealDto.getResultStatus();
        this.operatorName = appealDto.getOperatorName();
        this.localAvatar = appealDto.getLocalAvatar();
        this.nickName = appealDto.getNickName();
        this.wawaId = appealDto.getWawaId();
        this.wawaName = appealDto.getWawaName();
        this.catcherName = appealDto.getCatcherName();
        this.catcherId = appealDto.getCatcherId();
        this.videoUrl = appealDto.getVideoUrl();
        if (appealDto.getUserId() != null) {
            this.catchId = appealDto.getUserId() ^ BizConstants.USER_FIX_ID;
        }
        this.gmtCreate = DateUtils.getSecondStr(appealDto.getGmtCreate());
        this.gmtModified = DateUtils.getSecondStr(appealDto.getGmtModified());
        this.orderGmtCreate = DateUtils.getSecondStr(appealDto.getOrderGmtCreate());
        this.isCatched = appealDto.getIsCatched();
        this.result = appealDto.getResult();
        this.isReject = appealDto.getIsReject();
        this.price = appealDto.getPrice();
        this.vipLevel = appealDto.getVipLevel();
    }

}
