/**
 * Project Name:wawa-manager-biz File Name:JoinOrderVO.java Package Name:cn.com.wawa.manager.biz.vo
 * Date:2017年12月6日下午7:20:51 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.wawa.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.manager.common.constants.BizConstants;

/**
 * ClassName:JoinOrderVO <br/>
 * Date: 2017年12月6日 下午7:20:51 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel("参与订单详情")
public class JoinOrderVO {

    @ApiModelProperty("订单ID")
    private Long    id;

    @ApiModelProperty("用户ID")
    private Long    userId;

    @ApiModelProperty("订单状态:0-创建，1-抓中，2-未抓中")
    private Integer orderStatus;

    @ApiModelProperty("娃娃机ID")
    private Long    catcherId;

    @ApiModelProperty("娃娃ID")
    private Long    wawaId;

    @ApiModelProperty("视频URL")
    private String  videoUrl;

    @ApiModelProperty("费用")
    private Long    price;

    @ApiModelProperty("预期结果")
    private Integer expectResult;

    @ApiModelProperty("创建时间")
    private Date    gmtCreate;

    @ApiModelProperty("抓抓号")
    private String  zhuazhuaId;
    
    @ApiModelProperty("游戏时间")
    private String gameTime;

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * userId.
     *
     * @return the userId
     */
    public Long getUserId() {
        return userId;
    }

    /**
     * userId.
     *
     * @param userId the userId to set
     */
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    /**
     * orderStatus.
     *
     * @return the orderStatus
     */
    public Integer getOrderStatus() {
        return orderStatus;
    }

    /**
     * orderStatus.
     *
     * @param orderStatus the orderStatus to set
     */
    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    /**
     * catcherId.
     *
     * @return the catcherId
     */
    public Long getCatcherId() {
        return catcherId;
    }

    /**
     * catcherId.
     *
     * @param catcherId the catcherId to set
     */
    public void setCatcherId(Long catcherId) {
        this.catcherId = catcherId;
    }

    /**
     * wawaId.
     *
     * @return the wawaId
     */
    public Long getWawaId() {
        return wawaId;
    }

    /**
     * wawaId.
     *
     * @param wawaId the wawaId to set
     */
    public void setWawaId(Long wawaId) {
        this.wawaId = wawaId;
    }

    /**
     * videoUrl.
     *
     * @return the videoUrl
     */
    public String getVideoUrl() {
        return videoUrl;
    }

    /**
     * videoUrl.
     *
     * @param videoUrl the videoUrl to set
     */
    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    /**
     * price.
     *
     * @return the price
     */
    public Long getPrice() {
        return price;
    }

    /**
     * price.
     *
     * @param price the price to set
     */
    public void setPrice(Long price) {
        this.price = price;
    }

    /**
     * expectResult.
     *
     * @return the expectResult
     */
    public Integer getExpectResult() {
        return expectResult;
    }

    /**
     * expectResult.
     *
     * @param expectResult the expectResult to set
     */
    public void setExpectResult(Integer expectResult) {
        this.expectResult = expectResult;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * zhuazhuaId.
     *
     * @return the zhuazhuaId
     */
    public String getZhuazhuaId() {
        return String.valueOf(userId ^ BizConstants.USER_FIX_ID);
    }

    
    /**
     * gameTime.
     *
     * @return  the gameTime
     */
    public String getGameTime() {
        return DateUtils.getSecondStr(gmtCreate);
    }
}
