package cn.com.wawa.manager.biz.vo.title;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.service.api.dto.title.TitleConfigDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

@Data
@ApiModel(value = "称号配置")
@NoArgsConstructor
public class TitleConfigVO {

    @ApiModelProperty("主键")
    private int id;

    @ApiModelProperty("称号名称")
    private String name;

    @ApiModelProperty("称号图片")
    private String image;

    @ApiModelProperty("称号类型 1.成就 2.活动")
    private int type = 1;

    @ApiModelProperty("二级类别 11.累充 12.累计娃娃 13.连续抓中 14.一爪抓多只 21.充值排行榜 22.抓中排行榜")
    private int secondType = 11;

    @ApiModelProperty("上限条件 充值单位为元，抓中娃娃单位为只；type = 2，该字段有用")
    private int upperLimit;

    @ApiModelProperty("下限条件 充值单位为元，抓中娃娃单位为只")
    private int lowerLimit;

    @ApiModelProperty("获取条件文案")
    private String description;

    @ApiModelProperty("称号等级ID")
    private int levelId;

    @ApiModelProperty("有效天数 -1.永久")
    private int validDays = -1;

    @ApiModelProperty("是否展示称号进度 1.是 0.否")
    private int progressShow;

    @ApiModelProperty("获得的称号是否浮层展示 1.是 0.否")
    private int supernatantShow;

    @ApiModelProperty("称号备注")
    private String remark;

    @ApiModelProperty("称号状态 0.未上线 1.上线中 2. 已下线 3. 归档")
    private int status;

    @ApiModelProperty("上线时间")
    private String onlineTime;

    @ApiModelProperty("下线时间")
    private String offlineTime;

    @ApiModelProperty("创建时间")
    private String gmtCreate;

    @ApiModelProperty("修改时间")
    private String gmtModified;

    public TitleConfigVO(TitleConfigDto dto) {
        BeanUtils.copyProperties(dto, this);
        onlineTime = DateUtils.getSecondStr(dto.getOnlineTime());
        offlineTime = DateUtils.getSecondStr(dto.getOfflineTime());
        gmtCreate = DateUtils.getSecondStr(dto.getGmtCreate());
        gmtModified = DateUtils.getSecondStr(dto.getGmtModified());
    }
}
