package cn.com.wawa.manager.biz.bean;

import cn.com.wawa.service.api.bean.JsonResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
@ApiModel("加币保存bean")
public class AddCoinSaveBean {

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("加币类型 1.赠送币 2.充返币")
    private Integer addType;

    @ApiModelProperty("账户明细类型")
    private Integer accountType;

    @ApiModelProperty("加币金额")
    private Integer coin;

    @ApiModelProperty("用户id文件")
    private String userIdsFile;

    @ApiModelProperty("加币备注")
    private String addComment;

    public JsonResult check() {
        if (userId == null || userId < 1) {
            return JsonResult.failedResult("用户id不能为空");
        }
        if (coin == null || coin < 1 || coin >10000) {
            return JsonResult.failedResult("加币金额不合法");
        }
        return null;
    }

    public JsonResult checkBatchSave() {
        if (StringUtils.isBlank(userIdsFile)) {
            return JsonResult.failedResult("用户id不能为空");
        }
        if (coin == null || coin < 1 || coin >10000) {
            return JsonResult.failedResult("加币金额不合法");
        }
        return null;
    }
}
