package cn.com.wawa.manager.biz.bean;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("卡片编辑")
public class BannerCardSaveRequestBean {
    @ApiModelProperty("主键id")
    private Long id;
    @ApiModelProperty("卡片名称")
    private String cardName;
    @ApiModelProperty("卡片类型 1：功能型 2：运营型")
    private Integer cardType;
    @ApiModelProperty("卡片代码 0：默认 1：排行榜 2：周卡/月卡")
    private Integer cardCode;
    @ApiModelProperty("跳转链接")
    private String url;
    @ApiModelProperty("背景图片地址")
    private String image;
    @ApiModelProperty("文案描述")
    private String copywriting;
    @ApiModelProperty("扩展信息")
    private String extra;
    @ApiModelProperty("状态 1：上线 2：下线")
    private Integer cardStatus;
    @ApiModelProperty("用户类型 0:全部 1:未抓中过 2:抓中过")
    private Integer userType;
    @ApiModelProperty("排序")
    private Integer payload;
    @ApiModelProperty("充值后状态 1：上线 2：下线")
    private Integer chargeState;
    @ApiModelProperty("充值金额")
    private Long chargeMoney;
    @ApiModelProperty("定向Id")
    private Long redirectId;
    @ApiModelProperty("最小版本")
    private Integer minVersionCode;
    @ApiModelProperty("最大版本")
    private Integer maxVersionCode;
    @ApiModelProperty("平台 0：全部 1：IOS 2：ANDROID")
    private Integer clientType;
    @ApiModelProperty("上线时间")
    private String openTime;
    @ApiModelProperty("下线时间")
    private String closeTime;
}
