package cn.com.wawa.manager.biz.bean;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel("大弹窗新增/更新类")
public class BigPopSaveRequestBean {

    private Long id;

    @ApiModelProperty("图片地址")
    private String image;

    private String name;

    @ApiModelProperty("权重")
    private Long payload;

    private String onTime;

    private String offTime;

    private BigDecimal wide;
    private BigDecimal height;

    private Integer click;
    @ApiModelProperty("是否有关闭按钮")
    private Integer isClosed;

    private Integer clientType;

    private Long minVersionCode;

    private Long maxVersionCode;

    @ApiModelProperty("弹窗类型,引导点击弹窗传1，非引导传2")
    private Integer bigPopType;

    @ApiModelProperty("点击热区1类型 1不跳转、2跳转版本更新、3h5链接、原生页面链接、4调起快捷充值弹窗、5调起推送权限获取弹窗")
    private Integer leftBtnType;
    @ApiModelProperty("点击热区1后是否关闭 0否 1是")
    private Integer leftBtnClose;
    @ApiModelProperty("点击热区1后跳转地址")
    private String leftBtnUrl;

    @ApiModelProperty("点击热区2类型 1不跳转、2跳转版本更新、3h5链接、原生页面链接、4调起快捷充值弹窗、5调起推送权限获取弹窗")
    private Integer rightBtnType;
    @ApiModelProperty("点击热区2后是否关闭 0否 1是")
    private Integer rightBtnClose;
    @ApiModelProperty("点击热区2后跳转地址")
    private String rightBtnUrl;

}
