package cn.com.wawa.manager.biz.bean;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.Map;

@ApiModel(value = "推送消息")
@Data
public class PushMsgInfo {
    @ApiModelProperty(value = "自增Id")
    private Long id;
    @ApiModelProperty(value = "消息id")
    private Long msgId;
    @ApiModelProperty(value = "推送名称")
    private String pushName;
    @ApiModelProperty(value = "推送标题")
    private String pushTitle;
    @ApiModelProperty(value = "推送内容")
    private String pushContent;
    @ApiModelProperty(value = "跳转链接")
    private String url;
    @ApiModelProperty(value = "目标人群类型 1-全推  2-部分用户")
    private Map<String, String> targetUserType;
    @ApiModelProperty(value = "状态 1-未发送  2-待发送  3-已发送")
    private Map<String, String> pushStatus;
    @ApiModelProperty(value = "平台 0-安卓  1-ios  2-安卓和ios")
    private Map<String, String> client;
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date gmtCreate;
    @ApiModelProperty(value = "推送时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date pushTime;
    @ApiModelProperty(value = "目标推送用户量")
    private Long targetUserNum;
    @ApiModelProperty(value = "收到推送用户量")
    private Long receivedUserNum;
    @ApiModelProperty(value = "点击用户量")
    private Long clickUserNum;
    @ApiModelProperty(value = "推送用户文件")
    private String userIdsFile;


}
