package cn.com.wawa.manager.biz.service;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.wawa.manager.biz.bean.AdConfigSaveRequestBean;
import cn.com.wawa.manager.biz.tools.LocalDateUtil;
import cn.com.wawa.manager.biz.vo.AdConfigVO;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.AdConfigDto;
import cn.com.wawa.service.api.exception.BusinessException;
import cn.com.wawa.service.api.remoteservice.RemoteAdConfigService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;


@Service
public class AdConfigService {
    @Autowired
    private RemoteAdConfigService remoteAdConfigService;

    public AdConfigVO find(Long id) {
        AdConfigDto adConfigDto = remoteAdConfigService.find(id);
        if (adConfigDto != null) {
            return new AdConfigVO(adConfigDto);
        }
        return null;
    }


    /**
     * 获取adConfig分页列表
     *
     * @param pageIndex
     * @param pageSize
     * @param status
     * @return
     */
    public PagerResponse<AdConfigVO> page(int pageIndex, int pageSize, Integer status) {
        PagerResponse<AdConfigDto> page = remoteAdConfigService.page(new PagerRequest(pageIndex, pageSize), status);
        List<AdConfigVO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(page.getRecords())) {
            for (AdConfigDto adConfigDto : page.getRecords()) {
                list.add(new AdConfigVO(adConfigDto));
            }
        }
        return new PagerResponse<>(page, list);
    }

    /**
     * 新建或者保存
     *
     * @param adConfigSaveRequestBean
     * @return
     */
    public Boolean save(AdConfigSaveRequestBean adConfigSaveRequestBean) {
        AdConfigDto adConfigDto = BeanUtils.copy(adConfigSaveRequestBean, AdConfigDto.class);
        if (StringUtils.isNotBlank(adConfigSaveRequestBean.getOpenTime())) {
            adConfigDto.setOpenTime(LocalDateUtil.getHoruDbDate(adConfigSaveRequestBean.getOpenTime()));
        }
        if (StringUtils.isNotBlank(adConfigSaveRequestBean.getCloseTime())) {
            adConfigDto.setCloseTime(LocalDateUtil.getHoruDbDate(adConfigSaveRequestBean.getCloseTime()));
        }
        return remoteAdConfigService.save(adConfigDto);
    }


    /**
     * @param id
     * @return
     */
    public Boolean delete(Long id) {
        return remoteAdConfigService.delete(id);
    }

    public Boolean updateStatus(Long id, Integer status) {
        try {
            return remoteAdConfigService.setStatus(id, status);
        } catch (Exception e) {
            throw new BusinessException("最多上线6个，无法操作");
        }
    }


    public Boolean updatePayload(Long id, Integer payload) {
        return remoteAdConfigService.setPayload(id, payload);
    }

    public Integer countByStatus(Integer status) {
        return remoteAdConfigService.countByStatus(status);
    }

}
