package cn.com.wawa.manager.biz.service;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.wawa.manager.biz.bean.AddCoinSaveBean;
import cn.com.wawa.manager.common.constants.Admin;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.AddCoinDto;
import cn.com.wawa.service.api.remoteservice.RemoteAddCoinService;
import cn.com.wawa.service.api.remoteservice.RemoteUserManagerService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Service
public class AddCoinService {

    @Resource
    private RemoteAddCoinService remoteAddCoinService;

    @Resource
    private RemoteUserManagerService remoteUserManagerService;

    public JsonResult save(AddCoinSaveBean addCoinSaveBean) {
        AddCoinDto addCoinDto = buildAddCoinDto(addCoinSaveBean);
        if (remoteAddCoinService.insert(addCoinDto)) {
            return JsonResult.successResult("Success");
        }
        return JsonResult.failedResult("保存失败");
    }

    public JsonResult updateComment(String addComment, long id) {
        if (remoteAddCoinService.updateComment(addComment, id)) {
            return JsonResult.successResult("Success");
        }
        return JsonResult.failedResult("保存失败");
    }

    public JsonResult<AddCoinDto> get(long id) {
        AddCoinDto addCoinDto = remoteAddCoinService.find(id);
        return JsonResult.successResult(addCoinDto);
    }

    public JsonResult<PagerResponse<AddCoinDto>> list(PagerRequest pagerRequest, Long userId, String operatorEmail, String beginTime, String endTime, Integer accountType) {
        PagerResponse<AddCoinDto> list = remoteAddCoinService.list(pagerRequest, userId, operatorEmail, beginTime, endTime, accountType);
        if (list != null && !CollectionUtils.isEmpty(list.getRecords())) {
            List<AddCoinDto> records = list.getRecords();
            for (AddCoinDto record : records) {
                String email = record.getOperatorEmail();
                Map<String, String> account = this.getAccount();
                record.setOperatorEmail(account.get(email));
            }
        }
        return JsonResult.successResult(list);
    }

    public Map<String, String> getAccount() {
        return Admin.ACCOUNT;
    }

    public JsonResult batchInsert(AddCoinSaveBean addCoinSaveBean) {
        AddCoinDto addCoinDto = buildAddCoinDto(addCoinSaveBean);
        if (remoteAddCoinService.batchInsert(addCoinDto)) {
            return JsonResult.successResult("Success");
        }
        return JsonResult.failedResult("保存失败");
    }

    private AddCoinDto buildAddCoinDto(AddCoinSaveBean addCoinSaveBean) {
        AddCoinDto addCoinDto = new AddCoinDto();
        BeanUtils.copyProperties(addCoinSaveBean, addCoinDto);
        addCoinDto.setOperatorEmail(RequestTool.getAdmin().getEmail());
        return addCoinDto;
    }
}
