package cn.com.wawa.manager.biz.service;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.wawa.manager.biz.bean.BannerCardSaveRequestBean;
import cn.com.wawa.manager.biz.tools.LocalDateUtil;
import cn.com.wawa.manager.biz.vo.BannerCardVO;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.BannerCardDto;
import cn.com.wawa.service.api.remoteservice.RemoteBannerCardService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;


@Service
public class BannerCardService {
    @Autowired
    private RemoteBannerCardService remoteBannerCardService;

    public BannerCardVO find(Long id) {
        BannerCardDto bannerCardDto = remoteBannerCardService.find(id);
        if (bannerCardDto != null) {
            return new BannerCardVO(bannerCardDto);
        }
        return null;
    }


    /**
     * 获取bannerCard分页列表
     *
     * @param pageIndex
     * @param pageSize
     * @param status
     * @return
     */
    public PagerResponse<BannerCardVO> page(int pageIndex, int pageSize, Integer status, Integer userType, String cardName) {
        PagerResponse<BannerCardDto> page = remoteBannerCardService.page(new PagerRequest(pageIndex, pageSize), status, userType, cardName);
        List<BannerCardVO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(page.getRecords())) {
            for (BannerCardDto bannerCardDto : page.getRecords()) {
                list.add(new BannerCardVO(bannerCardDto));
            }
        }
        return new PagerResponse<>(page, list);
    }

    /**
     * 新建或者保存
     *
     * @param bannerCardSaveRequestBean
     * @return
     */
    public Boolean save(BannerCardSaveRequestBean bannerCardSaveRequestBean) {
        BannerCardDto bannerCardDto = BeanUtils.copy(bannerCardSaveRequestBean, BannerCardDto.class);
        if (StringUtils.isNotBlank(bannerCardSaveRequestBean.getOpenTime())) {
            bannerCardDto.setOpenTime(LocalDateUtil.getHoruDbDate(bannerCardSaveRequestBean.getOpenTime()));
        }
        if (StringUtils.isNotBlank(bannerCardSaveRequestBean.getCloseTime())) {
            bannerCardDto.setCloseTime(LocalDateUtil.getHoruDbDate(bannerCardSaveRequestBean.getCloseTime()));
        }
        Long chargeMoney = bannerCardSaveRequestBean.getChargeMoney();
        if(chargeMoney != null){
            bannerCardDto.setChargeMoney(chargeMoney * 100L);
        }
        return remoteBannerCardService.save(bannerCardDto);
    }


    /**
     * @param id
     * @return
     */
    public Boolean delete(Long id) {
        return remoteBannerCardService.delete(id);
    }

    public Boolean updateStatus(Long id, Integer status) {
        return remoteBannerCardService.setStatus(id, status);
    }


    public Boolean updatePayload(Long id, Integer payload) {
        return remoteBannerCardService.setPayload(id, payload);
    }

    public Integer countByStatus(Integer status, Integer type) {
        return remoteBannerCardService.countByStatus(status, type);
    }

}
