package cn.com.wawa.manager.biz.service;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.manager.biz.bean.BannerStatusRequestBean;
import cn.com.wawa.manager.biz.bean.ChargeBonusNormalBean;
import cn.com.wawa.manager.biz.bean.ChargePageRequestBean;
import cn.com.wawa.manager.biz.tools.LocalDateUtil;
import cn.com.wawa.manager.biz.vo.ChargeBonusBannerVO;
import cn.com.wawa.manager.biz.vo.ChargeBonusInfoVO;
import cn.com.wawa.manager.biz.vo.ChargeBonusNormalVO;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.ChargeBonusConfigDto;
import cn.com.wawa.service.api.enums.ChargeBonusConfigTypeEnum;
import cn.com.wawa.service.api.remoteservice.RemoteChargeBonusConfigService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Service
public class ChargeBonusConfigService {
    @Autowired
    private RemoteChargeBonusConfigService remoteChargeBonusConfigService;

    public ChargeBonusNormalVO find(Long id){
        ChargeBonusConfigDto chargeBonusConfigDto=remoteChargeBonusConfigService.find(id);
        if(chargeBonusConfigDto!=null){
            return convertToNormalVO(chargeBonusConfigDto);
        }
        return null;
    }

    public ChargeBonusBannerVO findBannerType(Long id){
        ChargeBonusConfigDto chargeBonusConfigDto=remoteChargeBonusConfigService.find(id);
        if(chargeBonusConfigDto!=null){
            return convertToBannerVO(chargeBonusConfigDto);
        }
        return null;
    }

    public Boolean updatePayload(Long id,Long payload){
        return remoteChargeBonusConfigService.updatePayload(id,payload)>0;
    }

    public Boolean updateStatus(BannerStatusRequestBean bannerStatusRequestBean){
        return remoteChargeBonusConfigService.setStatus(bannerStatusRequestBean.getId(),bannerStatusRequestBean.getStatus())>0;
    }

    public Boolean saveNormal(ChargeBonusNormalBean chargeBonusNormalBean){
        if(chargeBonusNormalBean!=null){
            ChargeBonusConfigDto chargeBonusConfigDto=BeanUtils.copy(chargeBonusNormalBean,ChargeBonusConfigDto.class);
            chargeBonusConfigDto.setBonusType(ChargeBonusConfigTypeEnum.NORMAL.value());
            chargeBonusConfigDto.setChargeMoney(chargeBonusNormalBean.getChargeMoney()*100);
            chargeBonusConfigDto.setBonusMoney(chargeBonusNormalBean.getBonusMoney()*10);
            if(StringUtils.isNotBlank(chargeBonusNormalBean.getOpenTime())){
                chargeBonusConfigDto.setOpenTime(LocalDateUtil.getHoruDbDate(chargeBonusNormalBean.getOpenTime()));
            }
            if(StringUtils.isNotBlank(chargeBonusNormalBean.getCloseTime())){
                chargeBonusConfigDto.setCloseTime(LocalDateUtil.getHoruDbDate(chargeBonusNormalBean.getCloseTime()));
            }
                JSONObject jsonObject=new JSONObject();
                if(chargeBonusNormalBean.getHotest()!=null&&chargeBonusNormalBean.getHotest()){
                    jsonObject.put("hottest","true");
                }
                if(chargeBonusNormalBean.getBonusMost()!=null&&chargeBonusNormalBean.getBonusMost()){
                    jsonObject.put("bonusMost","true");
                }
                if(StringUtils.isNotBlank(chargeBonusNormalBean.getSuperscript())){
                    jsonObject.put("superscript",chargeBonusNormalBean.getSuperscript());
                }
                chargeBonusConfigDto.setDetail(jsonObject.toJSONString());

           return remoteChargeBonusConfigService.save(chargeBonusConfigDto);
        }
        return false;
    }

    public boolean openBannerExists(Long id){

        List<ChargeBonusConfigDto> list=remoteChargeBonusConfigService.listByType(ChargeBonusConfigTypeEnum.FIRST_CHARGE.value(),0,new PagerRequest(1,50),1);
        if(CollectionUtils.isEmpty(list)){
            return false;
        }
        ChargeBonusConfigDto chargeBonusConfigDto=remoteChargeBonusConfigService.find(id);
        if(chargeBonusConfigDto==null){
            return false;
        }
        for(ChargeBonusConfigDto configDto:list){
            if(configDto.getId().equals(chargeBonusConfigDto.getId())){
                continue;
            }
            if((chargeBonusConfigDto.getClientType().equals(configDto.getClientType())||(chargeBonusConfigDto.getClientType()<=0||configDto.getClientType()<=0))){
                return true;
            }
        }
        return false;
    }

    public Boolean saveBanner(ChargeBonusBannerVO chargeBonusBannerVO){
        if(chargeBonusBannerVO!=null){
            ChargeBonusConfigDto chargeBonusConfigDto=BeanUtils.copy(chargeBonusBannerVO,ChargeBonusConfigDto.class);
            chargeBonusConfigDto.setBonusType(ChargeBonusConfigTypeEnum.FIRST_CHARGE.value());
            if(chargeBonusConfigDto.getBonusMoney()==null){
                chargeBonusConfigDto.setBonusMoney(0L);
            } else {
                chargeBonusConfigDto.setBonusMoney(chargeBonusBannerVO.getBonusMoney()*10);
            }
            if(chargeBonusConfigDto.getChargeMoney()==null){
                chargeBonusConfigDto.setChargeMoney(0L);
            } else {
                chargeBonusConfigDto.setChargeMoney(chargeBonusBannerVO.getChargeMoney()*100);
            }
            if(StringUtils.isNotBlank(chargeBonusBannerVO.getOpenTime())){
                chargeBonusConfigDto.setOpenTime(LocalDateUtil.getHoruDbDate(chargeBonusBannerVO.getOpenTime()));
            }
            if(StringUtils.isNotBlank(chargeBonusBannerVO.getCloseTime())){
                chargeBonusConfigDto.setCloseTime(LocalDateUtil.getHoruDbDate(chargeBonusBannerVO.getCloseTime()));
            }
            if(StringUtils.isNotBlank(chargeBonusBannerVO.getChargePagePic())||StringUtils.isNotBlank(chargeBonusBannerVO.getFastChargePic())||StringUtils.isNotBlank(chargeBonusBannerVO.getUrl())){
                JSONObject jsonObject=new JSONObject();
                if(StringUtils.isNotBlank(chargeBonusBannerVO.getChargePagePic())){
                    jsonObject.put("chargePagePic",chargeBonusBannerVO.getChargePagePic());
                }
                if(StringUtils.isNotBlank(chargeBonusBannerVO.getFastChargePic())){
                    jsonObject.put("fastChargePic",chargeBonusBannerVO.getFastChargePic());
                }
                if(StringUtils.isNotBlank(chargeBonusBannerVO.getUrl())){
                    jsonObject.put("url",chargeBonusBannerVO.getUrl());
                }
                chargeBonusConfigDto.setDetail(jsonObject.toJSONString());
            }
            return remoteChargeBonusConfigService.save(chargeBonusConfigDto);
        }
        return false;
    }


    public Boolean delete(Long id){
        return remoteChargeBonusConfigService.delete(id)>0;
    }

    public Boolean setStatus(Long id,Integer status){
        return remoteChargeBonusConfigService.setStatus(id,status)>0;
    }

    public int countStatus(Integer status){
        return remoteChargeBonusConfigService.countByStatus(status);
    }

    public ChargeBonusInfoVO count(){
        ChargeBonusInfoVO chargeBonusInfoVO=new ChargeBonusInfoVO();
        chargeBonusInfoVO.setEnableCount(remoteChargeBonusConfigService.countByStatus(1));
        chargeBonusInfoVO.setAllCount(chargeBonusInfoVO.getEnableCount()+remoteChargeBonusConfigService.countByStatus(0));
        return chargeBonusInfoVO;
    }

    public PagerResponse<ChargeBonusNormalVO> list(ChargePageRequestBean pageRequestBean){
        PagerRequest pageRequest=new PagerRequest(pageRequestBean.getPageIndex(),pageRequestBean.getPageSize());
        List<ChargeBonusConfigDto> list=remoteChargeBonusConfigService.listByType(ChargeBonusConfigTypeEnum.NORMAL.value(),pageRequestBean.getClientType(),pageRequest,pageRequestBean.getStatus());
        Integer count=remoteChargeBonusConfigService.countByType(ChargeBonusConfigTypeEnum.NORMAL.value(),pageRequestBean.getClientType(),pageRequestBean.getStatus());
        if(CollectionUtils.isNotEmpty(list)){
            List<ChargeBonusNormalVO> voList=new ArrayList<>();
            for(ChargeBonusConfigDto chargeBonusConfigDto:list){
                voList.add(convertToNormalVO(chargeBonusConfigDto));
            }
            return new PagerResponse<>(pageRequest,count,voList);
        }
        return new PagerResponse<>(pageRequest,0, Collections.emptyList());
    }

    public PagerResponse<ChargeBonusBannerVO> listForBannerType(ChargePageRequestBean pageRequestBean){
        PagerRequest pageRequest=new PagerRequest(pageRequestBean.getPageIndex(),pageRequestBean.getPageSize());
        List<ChargeBonusConfigDto> list=remoteChargeBonusConfigService.listByType(ChargeBonusConfigTypeEnum.FIRST_CHARGE.value(),pageRequestBean.getClientType(),pageRequest,pageRequestBean.getStatus());
        Integer count=remoteChargeBonusConfigService.countByType(ChargeBonusConfigTypeEnum.FIRST_CHARGE.value(),pageRequestBean.getClientType(),pageRequestBean.getStatus());
        if(CollectionUtils.isNotEmpty(list)){
            List<ChargeBonusBannerVO> voList=new ArrayList<>();
            for(ChargeBonusConfigDto chargeBonusConfigDto:list){
                voList.add(convertToBannerVO(chargeBonusConfigDto));
            }
            return new PagerResponse<>(pageRequest,count,voList);
        }
        return new PagerResponse<>(pageRequest,0, Collections.emptyList());
    }



    private ChargeBonusNormalVO convertToNormalVO(ChargeBonusConfigDto chargeBonusConfigDto){
        if(chargeBonusConfigDto!=null) {
            ChargeBonusNormalVO chargeBonusNormalVO = BeanUtils.copy(chargeBonusConfigDto, ChargeBonusNormalVO.class);
            if (chargeBonusConfigDto.getOpenTime() != null) {
                chargeBonusNormalVO.setOpenTime(DateUtils.getSecondStr(chargeBonusConfigDto.getOpenTime()));
            }
            chargeBonusNormalVO.setEnable(chargeBonusConfigDto.getEnable()>0);
            if (chargeBonusConfigDto.getCloseTime() != null) {
                chargeBonusNormalVO.setCloseTime(DateUtils.getSecondStr(chargeBonusConfigDto.getCloseTime()));
            }
            chargeBonusNormalVO.setGmtCreate(DateUtils.getSecondStr(chargeBonusConfigDto.getGmtCreate()));
            if(chargeBonusConfigDto.getBonusMoney()!=null){
                chargeBonusNormalVO.setBonusMoney(chargeBonusConfigDto.getBonusMoney()/10);//奖励展示的是抓抓币
            }
            if(chargeBonusConfigDto.getChargeMoney()!=null){
                chargeBonusNormalVO.setChargeMoney(chargeBonusConfigDto.getChargeMoney()/100);//充值金额展示的是元
            }
            if(StringUtils.isNotBlank(chargeBonusConfigDto.getDetail())){
                JSONObject jsonObject= JSON.parseObject(chargeBonusConfigDto.getDetail());
                if (jsonObject.containsKey("hottest") && BooleanUtils.toBoolean((String) jsonObject.get("hottest"))) {
                    chargeBonusNormalVO.setHotest(true);
                }
                if (jsonObject.containsKey("bonusMost") && BooleanUtils.toBoolean((String) jsonObject.get("bonusMost"))) {
                    chargeBonusNormalVO.setBonusMost(true);
                } if(jsonObject.containsKey("superscript")){
                    chargeBonusNormalVO.setSuperscript((String)jsonObject.get("superscript"));
                }
            }
            return chargeBonusNormalVO;
        }
        return null;
    }

    private ChargeBonusBannerVO convertToBannerVO(ChargeBonusConfigDto chargeBonusConfigDto){
        if(chargeBonusConfigDto!=null) {
            ChargeBonusBannerVO chargeBonusNormalVO = BeanUtils.copy(chargeBonusConfigDto, ChargeBonusBannerVO.class);
            if (chargeBonusConfigDto.getOpenTime() != null) {
                chargeBonusNormalVO.setOpenTime(DateUtils.getSecondStr(chargeBonusConfigDto.getOpenTime()));
            }
            if (chargeBonusConfigDto.getCloseTime() != null) {
                chargeBonusNormalVO.setCloseTime(DateUtils.getSecondStr(chargeBonusConfigDto.getCloseTime()));
            }
            chargeBonusNormalVO.setEnable(chargeBonusConfigDto.getEnable()>0);
            chargeBonusNormalVO.setGmtCreate(DateUtils.getSecondStr(chargeBonusConfigDto.getGmtCreate()));
            if(chargeBonusConfigDto.getBonusMoney()!=null){
                chargeBonusNormalVO.setBonusMoney(chargeBonusConfigDto.getBonusMoney()/10);//奖励展示的是抓抓币
            }
            if(chargeBonusConfigDto.getChargeMoney()!=null){
                chargeBonusNormalVO.setChargeMoney(chargeBonusConfigDto.getChargeMoney()/100);//充值金额展示的是元
            }
            if(StringUtils.isNotBlank(chargeBonusConfigDto.getDetail())){
                JSONObject jsonObject= JSON.parseObject(chargeBonusConfigDto.getDetail());
                if (jsonObject.containsKey("chargePagePic")) {
                    chargeBonusNormalVO.setChargePagePic(jsonObject.getString("chargePagePic"));
                }
                if (jsonObject.containsKey("fastChargePic")) {
                    chargeBonusNormalVO.setFastChargePic(jsonObject.getString("fastChargePic"));
                }
                if(jsonObject.containsKey("url")){
                    chargeBonusNormalVO.setUrl(jsonObject.getString("url"));
                }
            }
            return chargeBonusNormalVO;
        }
        return null;
    }



}
