package cn.com.wawa.manager.biz.service;

import cn.com.wawa.manager.biz.vo.PagenationVO;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.manager.biz.bean.DeliveryBean;
import cn.com.wawa.manager.biz.bean.DeliveryOrderExportBean;
import cn.com.wawa.manager.biz.bean.DeliveryOrderQueryBean;
import cn.com.wawa.manager.biz.task.SendApplyExportRunnable;
import cn.com.wawa.manager.biz.vo.DeliveryOrderVO;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.DeliveryDto;
import cn.com.wawa.service.api.dto.DeliveryOrderDto;
import cn.com.wawa.service.api.dto.UserCatchedWawaDto;
import cn.com.wawa.service.api.enums.DeliveryStatusEnum;
import cn.com.wawa.service.api.exception.BusinessException;
import cn.com.wawa.service.api.query.DeliveryOrderQuery;
import cn.com.wawa.service.api.remoteservice.RemoteDeliveryOrderService;
import com.google.common.base.Preconditions;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * Created by gyf .
 * 2017/10/31 .
 */
@Service("deliveryService")
public class DeliveryService implements ApplicationContextAware {

    private static final Logger LOGGER = LoggerFactory.getLogger(DeliveryService.class);

    private ApplicationContext applicationContext;

    @Autowired
    private RemoteDeliveryOrderService remoteDeliveryOrderService;

    @Resource
    private ExecutorService executorService;

    /**
     * 分页列表查询发货订单
     * @param pageIndex
     * @param pageSize
     * @param userId
     * @param deliveryStatus
     * @return
     */
    public PagerResponse<DeliveryOrderVO> page(Integer pageIndex, Integer pageSize, Long userId, Integer deliveryStatus) {
        Preconditions.checkNotNull(deliveryStatus, "发货订单状态不能为null");

        DeliveryStatusEnum deliveryStatusEnum = DeliveryStatusEnum.get(deliveryStatus);
        Preconditions.checkNotNull(deliveryStatusEnum, "枚举校验异常");

        PagerRequest pagerRequest = new PagerRequest(pageIndex, pageSize);

        PagerResponse<DeliveryOrderDto> page = remoteDeliveryOrderService.page(userId, deliveryStatusEnum, pagerRequest);
        List<DeliveryOrderDto> dtos = page.getRecords();
        return new PagerResponse<>(page, BeanUtils.copyList(dtos, DeliveryOrderVO.class));
    }

    /**
     * 发货处理
     * @param bean
     * @return
     */
    public Boolean send(DeliveryBean bean) {
        DeliveryDto dto = BeanUtils.copy(bean, DeliveryDto.class);
        dto.setDeliveryTime(new Date());
        return remoteDeliveryOrderService.send(dto);
    }

    /**
     * 导出未发货订单
     */
    public Map<String, Object> sendApplyExport(HttpServletResponse response,DeliveryOrderQueryBean queryBean,Integer deliveryStatus){
        DeliveryOrderQuery query = new DeliveryOrderQuery();
        query.setStartTime(queryBean.getStartTime());
        query.setEndTime(queryBean.getEndTime());
        DeliveryStatusEnum deliveryStatusEnum = DeliveryStatusEnum.get(deliveryStatus);
        query.setDeliveryStatus(deliveryStatusEnum == null ? DeliveryStatusEnum.COCK.value() : deliveryStatusEnum.value());//默认待发货
        List<DeliveryOrderDto> deliveryOrderDtos = remoteDeliveryOrderService.findDeliveryOrderByQuery(query);
        //过滤没有娃娃的申请
        List<DeliveryOrderDto> hasWawaDeliverys = deliveryOrderDtos.stream().filter(e ->
            CollectionUtils.isNotEmpty(e.getWawaDetail())
        ).collect(Collectors.toList());
        //一个娃娃对应一条记录,如果2个则对应2条导出记录
        CopyOnWriteArrayList<DeliveryOrderExportBean> deliveryOrderExportBeans = new CopyOnWriteArrayList();
        hasWawaDeliverys.stream().forEach(deliveryOrderDto ->{
            List<UserCatchedWawaDto> userCatchedWawaDtos = deliveryOrderDto.getWawaDetail();
            userCatchedWawaDtos.forEach(userCatchedWawaDto -> {
                for (int i = 0;i<userCatchedWawaDto.getQuantity();i++){
                    DeliveryOrderExportBean deliveryOrderExportBean = BeanUtils.copy(deliveryOrderDto,DeliveryOrderExportBean.class);
                    deliveryOrderExportBean.setUserCatchedWawaDto(userCatchedWawaDto);
                    deliveryOrderExportBeans.add(deliveryOrderExportBean);
                }
            });
        });
        if (CollectionUtils.isEmpty(deliveryOrderExportBeans))
            throw new BusinessException("该时间段可导出数据为空");
        SendApplyExportRunnable runnable = applicationContext.getBean(SendApplyExportRunnable.class);
        runnable.setResponse(response);
        runnable.setDeliveryOrderExportBeans(deliveryOrderExportBeans);
        Map<String, Object> info = runnable.init();
        Future<Boolean> result = executorService.submit(runnable);
        //防止线程池任务未结束,但是结果已经返回,所以这边使用callBack调用future的get阻塞一下,保证流的数据完整性
        try {
            LOGGER.info("导出结果为 result={}",result.get());
        } catch (InterruptedException e) {
            LOGGER.error("thread interrupted msg={}",e);
            Thread.currentThread().interrupt();
        } catch (ExecutionException e) {
            LOGGER.error("export data error msg={}",e);
        }
        return info;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
