package cn.com.wawa.manager.biz.service;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.wawa.manager.biz.bean.FloorSaveRequestBean;
import cn.com.wawa.manager.biz.vo.FloorVO;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.FloorDto;
import cn.com.wawa.service.api.remoteservice.RemoteFloorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;


@Service
public class FloorService {
    @Autowired
    private RemoteFloorService remoteFloorService;

    public FloorVO find(Long id) {
        FloorDto floorDto = remoteFloorService.find(id);
        if (floorDto != null) {
            return new FloorVO(floorDto);
        }
        return null;
    }


    /**
     * 获取floor分页列表
     *
     * @param pageIndex
     * @param pageSize
     * @param status
     * @return
     */
    public PagerResponse<FloorVO> page(int pageIndex, int pageSize, Integer status, Integer type) {
        PagerResponse<FloorDto> page = remoteFloorService.page(new PagerRequest(pageIndex, pageSize), status, type);
        List<FloorVO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(page.getRecords())) {
            for (FloorDto floorDto : page.getRecords()) {
                list.add(new FloorVO(floorDto));
            }
        }
        return new PagerResponse<>(page, list);
    }

    /**
     * 新建或者保存
     *
     * @param floorSaveRequestBean
     * @return
     */
    public Boolean save(FloorSaveRequestBean floorSaveRequestBean) {
        FloorDto floorDto = BeanUtils.copy(floorSaveRequestBean, FloorDto.class);
        return remoteFloorService.save(floorDto);
    }


    /**
     * @param id
     * @return
     */
    public Boolean delete(Long id) {
        return remoteFloorService.delete(id);
    }

    public Boolean updateStatus(Long id, Integer status) {
        return remoteFloorService.setStatus(id, status);
    }


    public Boolean updatePayload(Long id, Long payload) {
        return remoteFloorService.setPayload(id, payload);
    }

    public Integer countByStatus(Integer status, Integer type) {
        return remoteFloorService.countByStatus(status, type);
    }

}
