package cn.com.wawa.manager.biz.service;
import cn.com.wawa.manager.biz.bean.groupbook.AwardUpdateBean;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.groupbook.GroupBookAwardDto;
import cn.com.wawa.service.api.remoteservice.groupbook.RemoteOpenGroupAwardService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class GroupBookAwardService {

    @Resource
    private RemoteOpenGroupAwardService awardService;

    public JsonResult updateDeliveryInfo(AwardUpdateBean param) {
        return awardService.addDeliveryInfo(param.getLogisticsName(), param.getLogisticsCode(), param.getId());
    }

    public PagerResponse<GroupBookAwardDto> list(Integer pageIndex, Integer pageSize) {
        return awardService.page(new PagerRequest(pageIndex, pageSize));
    }
}
