package cn.com.wawa.manager.biz.service;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.CenterMsgDto;
import cn.com.wawa.service.api.enums.PushTargetUser;
import cn.com.wawa.service.api.enums.PushUrlType;
import cn.com.wawa.service.api.remoteservice.RemoteCenterMsgManagerService;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
public class MsgCenterService {

    @Resource
    private RemoteCenterMsgManagerService managerService;

    public PagerResponse<CenterMsgDto> page(Integer pageIndex, Integer pageSize, Integer msgType, String msgName, String sendTimeStart, String sendTimeEnd) {
        return managerService.page(pageIndex, pageSize, msgType, msgName, sendTimeStart, sendTimeEnd);
    }

    public CenterMsgDto getPushInfo(Long msgId) {
        return managerService.getPushInfo(msgId);
    }

    public JsonResult save(CenterMsgDto dto) {
        if (dto.getTargetUserType() == PushTargetUser.PART.getCode() && Strings.isNullOrEmpty(dto.getUserIdsFile())) {
            return JsonResult.failedResult("用户id文件不能为空");
        }
        return managerService.save(dto);
    }

    public JsonResult start(Long msgId) {
        return managerService.start(msgId);
    }

    public JsonResult close(Long msgId) {
        return managerService.close(msgId);
    }

    public JsonResult delete(Long msgId) {
        return managerService.delete(msgId);
    }

    public JsonResult testMsgSend(String userIds, Long msgId) {
        List<String> userIdList = Splitter.on(",").trimResults().splitToList(userIds);
        Set<Long> collect = userIdList.stream().map(userId -> NumberUtils.toLong(userId, 0)).collect(Collectors.toSet());
        return managerService.testSend(collect, msgId);
    }
}
