package cn.com.wawa.manager.biz.service;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.wawa.manager.biz.bean.PushMsgInfo;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.PushInfoDto;
import cn.com.wawa.service.api.enums.PushClient;
import cn.com.wawa.service.api.enums.PushStatus;
import cn.com.wawa.service.api.enums.PushTargetUser;
import cn.com.wawa.service.api.enums.PushUrlType;
import cn.com.wawa.service.api.remoteservice.RemotePushManagerService;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Service
public class PushService {

    @Resource
    private RemotePushManagerService pushManagerService;

    public PagerResponse<PushMsgInfo> page(Integer pageIndex, Integer pageSize, Integer pushStatus, String pushName, String pushTimeStart, String pushTimeEnd) {
        PagerResponse<PushInfoDto> page = pushManagerService.page(pageIndex, pageSize, pushStatus, pushName, pushTimeStart, pushTimeEnd);
        List<PushMsgInfo> pushMsgInfoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            page.getRecords().forEach(pushInfoDto -> {
                pushMsgInfoList.add(buildPushMsgInfo(pushInfoDto));
            });
        }

        return new PagerResponse<>(page, pushMsgInfoList);
    }

    public PushMsgInfo getPushInfo(Long pushId) {
        PushInfoDto pushInfo = pushManagerService.getPushInfo(pushId);
        if (pushInfo == null) {
            return null;
        }
        return buildPushMsgInfo(pushInfo);
    }

    private PushMsgInfo buildPushMsgInfo(PushInfoDto pushInfo) {
        PushMsgInfo ret = BeanUtils.copy(pushInfo, PushMsgInfo.class);
        ret.setClient(buildMap(String.valueOf(PushClient.getPushClient(pushInfo.getClient()).getCode()), PushClient.getPushClient(pushInfo.getClient()).getDesc()));
        ret.setPushStatus(buildMap(String.valueOf(PushStatus.getPushStatus(pushInfo.getPushStatus()).getCode()), PushStatus.getPushStatus(pushInfo.getPushStatus()).getDesc()));
        ret.setTargetUserType(buildMap(String.valueOf(PushTargetUser.getPushTargetUser(pushInfo.getTargetUserType()).getCode()), PushTargetUser.getPushTargetUser(pushInfo.getTargetUserType()).getDesc()));
        ret.setReceivedUserNum(pushInfo.getReceivedUserNum() == null ? 0 : pushInfo.getReceivedUserNum());
        ret.setTargetUserNum(pushInfo.getTargetUserNum() == null ? 0 : pushInfo.getTargetUserNum());
        ret.setClickUserNum(pushInfo.getClickUserNum() == null ? 0 : pushInfo.getClickUserNum());
        return ret;
    }

    public JsonResult save(PushMsgInfo pushMsgInfo) {
        PushInfoDto copy = BeanUtils.copy(pushMsgInfo, PushInfoDto.class);
        copy.setTargetUserType(NumberUtils.toInt(pushMsgInfo.getTargetUserType().get("value"), 1));
        copy.setClient(NumberUtils.toInt(pushMsgInfo.getClient().get("value"), 0));
        if (copy.getTargetUserType() == PushTargetUser.PART.getCode() && Strings.isNullOrEmpty(pushMsgInfo.getUserIdsFile())) {
            return JsonResult.failedResult("用户id文件不能为空");
        }
        copy.setUrlType(pushMsgInfo.getUrl().startsWith("tm:") ? PushUrlType.YUANSHENG.getCode() : PushUrlType.H5.getCode());
        copy.setMsgId(0L);
        return pushManagerService.save(copy);
    }

    public JsonResult start(Long pushId) {
        return pushManagerService.start(pushId);
    }

    public JsonResult close(Long pushId) {
        return pushManagerService.close(pushId);
    }

    public JsonResult delete(Long pushId) {
        return pushManagerService.delete(pushId);
    }

    public JsonResult testPush(String userIds, Long pushId) {
        List<String> userIdList = Splitter.on(",").trimResults().splitToList(userIds);
        Set<Long> collect = userIdList.stream().map(userId -> NumberUtils.toLong(userId, 0)).collect(Collectors.toSet());
        return pushManagerService.testPush(collect.stream().map(id -> String.valueOf(id)).collect(Collectors.toSet()), pushId);
    }

    public Map<String, String> buildMap(String value, String text) {
        Map<String, String> map = Maps.newHashMap();
        map.put("value", value);
        map.put("text", text);
        return map;
    }
}
