package cn.com.wawa.manager.biz.service;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.StaticPageDto;
import cn.com.wawa.service.api.remoteservice.RemoteStaticPageService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class StaticPageService {

    @Resource
    private RemoteStaticPageService remoteStaticPageService;

    public PagerResponse<StaticPageDto> page(Integer pageIndex, Integer pageSize) {
        PagerRequest pagerRequest = new PagerRequest(pageIndex == null ? 1 : pageIndex, pageSize == null ? 20 : pageSize);
        return remoteStaticPageService.page(pagerRequest);
    }

    public JsonResult delete(Long id) {
        return remoteStaticPageService.delete(id);
    }

    public JsonResult save(StaticPageDto dto) {
        return remoteStaticPageService.insert(dto);
    }

    public StaticPageDto find(Long id) {
        return remoteStaticPageService.find(id);
    }
}
