package cn.com.wawa.manager.biz.service;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.manager.biz.bean.user.UserDetailQueryBean;
import cn.com.wawa.manager.biz.bean.user.UserMoneyQueryBean;
import cn.com.wawa.manager.biz.bean.user.UserQueryBean;
import cn.com.wawa.manager.biz.vo.TimeLimitRecordVO;
import cn.com.wawa.manager.biz.vo.user.CatchCoinDetailVO;
import cn.com.wawa.manager.biz.vo.user.UserDetailVO;
import cn.com.wawa.manager.biz.vo.user.UserManagerVO;
import cn.com.wawa.manager.biz.vo.user.UserWawaWinVO;
import cn.com.wawa.manager.common.constants.BizConstants;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.*;
import cn.com.wawa.service.api.dto.user.UserAddressDto;
import cn.com.wawa.service.api.dto.user.UserCoinDto;
import cn.com.wawa.service.api.dto.user.UserCoinRecordDto;
import cn.com.wawa.service.api.dto.user.UserDetailDto;
import cn.com.wawa.service.api.dto.user.UserDto;
import cn.com.wawa.service.api.enums.*;
import cn.com.wawa.service.api.query.UserManagerQuery;
import cn.com.wawa.service.api.remoteservice.RemoteAddCoinService;
import cn.com.wawa.service.api.remoteservice.RemoteTimeLimitRecordService;
import cn.com.wawa.service.api.remoteservice.RemoteTimeLimitResultRecordService;
import cn.com.wawa.service.api.remoteservice.RemoteUserManagerService;
import cn.com.wawa.service.api.remoteservice.RemoteWawaBattleService;
import cn.com.wawa.service.api.remoteservice.RemoteWawaCatcherService;
import cn.com.wawa.service.api.remoteservice.RemoteWawaService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * Created by danke on 2017/12/11.
 * 用户管理service
 */
@Service
public class UserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserService.class);

    private static final String WIN = "胜利";

    private static final String LOSE = "失败";

    private static final String EQUAL = "平局";

    @Resource
    private RemoteUserManagerService remoteUserManagerService;

    @Resource
    private RemoteWawaService remoteWawaService;

    @Resource
    private RemoteTimeLimitResultRecordService timeLimitResultRecordService;

    @Resource
    private RemoteWawaCatcherService remoteWawaCatcherService;

    @Autowired
    private RemoteWawaBattleService remoteWawaBattleService;

    @Autowired
    private RemoteTimeLimitRecordService remoteTimeLimitRecordService;

    @Autowired
    private RemoteAddCoinService remoteAddCoinService;

    @Autowired
    private AddCoinService addCoinService;

    @Resource
    private ExecutorService executorService;

    //导出vip用户最多只能导出20000个用户
    private int EXPORT_MAX_COUNT = 20000;

    /**
     * 查询用户管理界面
     */
    public PagerResponse<UserManagerVO> queryUserManager(UserQueryBean queryBean) {
        UserManagerQuery userManagerQuery = BeanUtils.copy(queryBean, UserManagerQuery.class);
        userManagerQuery.setNickName(queryBean.getNikeName());
        if (null != queryBean.getZhuazhuaId()) {
            userManagerQuery.setUserId(BizConstants.USER_FIX_ID ^ queryBean.getZhuazhuaId());
        }
        PagerRequest pagerRequest = new PagerRequest(queryBean.getPageIndex(), queryBean.getPageSize());
        PagerResponse<UserDto> userDtoPage = remoteUserManagerService.findUserByQuery(userManagerQuery, pagerRequest);
        List<UserDto> userDtos = userDtoPage.getRecords();
        List<UserManagerVO> userManagerVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(userDtos)) {
            userManagerVOS = userDtos.stream().map(userDto -> {
                UserManagerVO userManagerVO = new UserManagerVO();
                userManagerVO.setNikeName(userDto.getNickName());
                userManagerVO.setWxAvatar(userDto.getLocalAvatar());
                userManagerVO.setUserType(StringUtils.isBlank(userDto.getUserType()) ?
                        UserTypeEnum.ORDINARY_USER.getMsg() : UserTypeEnum.get(userDto.getUserType()).getMsg());
                userManagerVO.setZhuazhuaId(BizConstants.USER_FIX_ID ^ userDto.getId());
                userManagerVO.setUserId(userDto.getId());
                userManagerVO.setCatchCoin(userDto.getFreeCoin() + userDto.getBonusCoin() + userDto.getCoin());
                userManagerVO.setAllCatchCoin(userDto.getUserCoinDto() == null ? 0 : userDto.getUserCoinDto().getAllCatchCoin());
                userManagerVO.setWawaDepositNum(userDto.getWawaDepositNum() == null ? 0 : userDto.getWawaDepositNum());
                userManagerVO.setWawaAllNum(userDto.getWawaAllNum() == null ? 0 : userDto.getWawaAllNum());
                userManagerVO.setRegisterTime(DateUtils.getSecondStr(userDto.getGmtCreate()));
                userManagerVO.setBlack(userDto.isBlack());
                userManagerVO.setUserChannel(userDto.getUserChannel());
                userManagerVO.setVipLevel(userDto.getVipLevel());
                return userManagerVO;
            }).collect(Collectors.toList());
        }
        PagerResponse resultBase = new PagerResponse();
        resultBase.setRecords(userManagerVOS);
        resultBase.setTotalRecords(userDtoPage.getTotalRecords());
        resultBase.setPageIndex(queryBean.getPageIndex());
        resultBase.setPageSize(queryBean.getPageSize());
        return resultBase;
    }

    /**
     * 查询用户详情页面
     */
    public UserDetailVO queryUserDetail(UserDetailQueryBean queryBean) {
        UserDetailVO userDetailVO = new UserDetailVO();
        UserDetailDto userDetailDto = remoteUserManagerService.queryUserDetailById(queryBean.getUserId());
        UserDto userDto = userDetailDto.getUserDto();
        if (null == userDto)
            return new UserDetailVO();
        List<WinOrderDto> winOrderDtos = userDetailDto.getWinOrderDtos();

        userDetailVO.setNickName(userDto.getNickName());
        userDetailVO.setWxAvatar(userDto.getWxAvatar());
        userDetailVO.setZhuazhuaId(BizConstants.USER_FIX_ID ^ userDto.getId());
        userDetailVO.setUserType(StringUtils.isBlank(userDto.getUserType()) ?
                UserTypeEnum.ORDINARY_USER.getMsg() : UserTypeEnum.get(userDto.getUserType()).getMsg());
        userDetailVO.setUserId(userDto.getId());
        userDetailVO.setCatchCoin(userDto.getFreeCoin() + userDto.getBonusCoin() + userDto.getCoin());

        userDetailVO.setWawaDepositNum(userDto.getWawaDepositNum() == null ? 0 : userDto.getWawaDepositNum());
        userDetailVO.setWawaAllNum(userDto.getWawaAllNum() == null ? 0 : userDto.getWawaAllNum());
        userDetailVO.setBlack(userDto.isBlack());
        userDetailVO.setRegisterTime(DateUtils.getSecondStr(userDto.getGmtCreate()));
        userDetailVO.setFreeCoin(userDto.getFreeCoin());
        userDetailVO.setBaseCoin(userDto.getCoin());
        userDetailVO.setBonusCoin(userDto.getBonusCoin());
        UserCoinDto userCoinDto = userDto.getUserCoinDto();
        userDetailVO.setAllCatchCoin(userCoinDto == null ? 0 : userCoinDto.getAllCatchCoin());
        userDetailVO.setAllFreeCoin(userCoinDto == null ? 0 : userCoinDto.getAllFreeCoin());
        userDetailVO.setAllBaseCoin(userCoinDto == null ? 0 : userCoinDto.getAllBaseCoin());
        userDetailVO.setAllBonusCoin(userCoinDto == null ? 0 : userCoinDto.getAllBonusCoin());

        userDetailVO.setBalance(userDto.getBalance());
        userDetailVO.setCountHistory(userDto.getCountHistory());
        userDetailVO.setClassicGameCost(userDto.getClassicGameCost());
        userDetailVO.setTimeLimitGameCost(userDto.getTimeLimitGameCost());

        userDetailVO.setWinRate(userDto.getWinRate());
        userDetailVO.setCountCostPrice(userDto.getCountCostPrice());
        userDetailVO.setCountFee(userDto.getCountFee());
        userDetailVO.setCountWinCoin(userDto.getCountWinCoin());
        userDetailVO.setTotalNum(userDto.getTotalNum());
        userDetailVO.setTotalWin(userDto.getTotalWin());

        userDetailVO.setTotalCatchRate(userDto.getTotalCatchRate());
        userDetailVO.setStrongCatchRate(userDto.getStrongCatchRate());
        userDetailVO.setWeakCatchRate(userDto.getWeakCatchRate());
        UserAddressDto userAddressDto = userDto.getUserAddressDto();
        if (null != userAddressDto) {
            userDetailVO.setReveiver(userAddressDto.getReveiver());
            userDetailVO.setPhone(userAddressDto.getPhone());
            StringBuffer sb = new StringBuffer();
            sb.append(userAddressDto.getAddrProvince())
                    .append(userAddressDto.getAddrCity())
                    .append(userAddressDto.getAddrArea())
                    .append(userAddressDto.getAddrDetail());
            userDetailVO.setAddrDetail(sb.toString());
        }
        List<UserWawaWinVO> userWawaWinVOS = new ArrayList<>();

        if (CollectionUtils.isNotEmpty(winOrderDtos)) {
            List<Long> wawaIds = winOrderDtos.stream().map(WinOrderDto::getWawaId).collect(Collectors.toList());
            Map<Long, WawaDto> wawaMap = new HashMap<>();
            List<WawaDto> wawas = remoteWawaService.findByIds(wawaIds);
            for (WawaDto it : wawas) {
                wawaMap.put(it.getId(), it);
            }
            userWawaWinVOS = winOrderDtos.stream().map(winOrderDto -> {
                UserWawaWinVO userWawaWinVO = new UserWawaWinVO();
                userWawaWinVO.setWawaId(winOrderDto.getWawaId());
                userWawaWinVO.setWawaName(winOrderDto.getWawaName());
                String statusDesc = WinOrderStatusEnum.get(winOrderDto.getWinOrderStatus()).desc();
                if (winOrderDto.getWinOrderStatus() == WinOrderStatusEnum.CONVERSION.value() || winOrderDto.getWinOrderStatus() == WinOrderStatusEnum.PAST_DUE.value()) {
                    statusDesc = String.format(statusDesc, conversionPercent(wawaMap.get(winOrderDto.getWawaId())));
                }
                userWawaWinVO.setWinOrderStatus(statusDesc);
                userWawaWinVO.setVideoUrl(winOrderDto.getVideoUrl());
                userWawaWinVO.setGmtCreate(DateUtils.getSecondStr(winOrderDto.getGmtCreate()));
                return userWawaWinVO;
            }).collect(Collectors.toList());
        }
        userDetailVO.setWinOrderVOS(userWawaWinVOS);
        return userDetailVO;
    }

    /**
     * 查询用户抓抓币记录详情
     */
    public PagerResponse<CatchCoinDetailVO> queryCatchCoinDetail(UserMoneyQueryBean queryBean) {
        PagerRequest page = new PagerRequest(queryBean.getPageIndex(), queryBean.getPageSize());
        Long userId = queryBean.getUserId();
        String startTime = queryBean.getStartTime();
        String endTime = queryBean.getEndTime();
        if (StringUtils.isBlank(endTime)) {
            endTime = DateUtils.getSecondStr(new Date());
        }
        List<UserCoinRecordDto> userCoinRecordDtos = remoteUserManagerService.queryUserCoinRecord(startTime, endTime, userId, page);
        if (CollectionUtils.isEmpty(userCoinRecordDtos)){
            return new PagerResponse<>();
        }
        int count = remoteUserManagerService.countUserCoinRecordByQuery(startTime, endTime, userId);
        List<CatchCoinDetailVO> catchCoinDetailVOS = userCoinRecordDtos.stream().map(userCoinRecordDto -> {
            CatchCoinDetailVO catchCoinDetailVO = new CatchCoinDetailVO();
            //打底
            catchCoinDetailVO.setCatcherStatus(StringUtils.EMPTY);
            catchCoinDetailVO.setVideoUrl(StringUtils.EMPTY);
            catchCoinDetailVO.setCatcherName(StringUtils.EMPTY);
            catchCoinDetailVO.setJoinOrderId(StringUtils.EMPTY);
            catchCoinDetailVO.setDetail(AccountChangeTypeEnum.get(userCoinRecordDto.getChangeType()).desc());
            catchCoinDetailVO.setRechargeNum(userCoinRecordDto.getCoin() == null ? "0" : "+" + userCoinRecordDto.getCoin());
            if (userCoinRecordDto.getChangeType() == AccountChangeTypeEnum.CATCH_WAWA.value()) {
                //抓娃娃消费,填充抓取状态和视频地址
                catchCoinDetailVO.setCatcherStatus(getStatusDesc(userCoinRecordDto.getOrderStatus()));
                catchCoinDetailVO.setVideoUrl(StringUtils.isBlank(userCoinRecordDto.getVideoUrl()) ? StringUtils.EMPTY : userCoinRecordDto.getVideoUrl());
                catchCoinDetailVO.setDetail("抓 " + userCoinRecordDto.getWawaName());
                catchCoinDetailVO.setCatcherName(userCoinRecordDto.getCatcherName());
                Long joinOrderId = userCoinRecordDto.getJoinOrderId();
                catchCoinDetailVO.setJoinOrderId(joinOrderId == null ? "" : joinOrderId.toString());
                if (AccountChangeTypeEnum.get(userCoinRecordDto.getChangeType()).code() == 1) {
                    catchCoinDetailVO.setRechargeNum(userCoinRecordDto.getCoin() == null ? "0" : "-" + userCoinRecordDto.getCoin());
                }
            } else if (userCoinRecordDto.getChangeType() == AccountChangeTypeEnum.LIMIT_CATCH_WAWA.value()) {
                Long relationId = userCoinRecordDto.getRelationId();
                TimeLimitResultRecordDto dto = timeLimitResultRecordService.find(relationId);
                if (dto != null) {
                    catchCoinDetailVO.setCatcherStatus("抓中" + dto.getCatchedNum() + "只 得分" + dto.getScore() + " 连抓" + dto.getContinuousCatchedNum() + "只 " + (dto.getTicketNum()==null?0:dto.getTicketNum()) + "张兑换券 ");
                    catchCoinDetailVO.setVideoUrl(dto.getVideoUrl());
                    WawaCatcherSimpleDto catcher = remoteWawaCatcherService.find(dto.getCatcherId());
                    if (catcher != null) {
                        catchCoinDetailVO.setCatcherName(catcher.getCatcherName());
                    }
                }
                catchCoinDetailVO.setDetail("限时玩法-单人场");
                catchCoinDetailVO.setJoinOrderId(relationId.toString());
                catchCoinDetailVO.setRechargeNum(userCoinRecordDto.getCoin() == null ? "0" : "-" + userCoinRecordDto.getCoin());
            } else if (userCoinRecordDto.getChangeType() == AccountChangeTypeEnum.LIMIT_CATCH_1V1.value()) {
                Long relationId = userCoinRecordDto.getRelationId();
                TimeLimitResultRecordDto dto = timeLimitResultRecordService.find(relationId);
                if (dto != null) {
                    //查询是否胜利 tb_wawa_battle
                    catchCoinDetailVO.setCatcherStatus("抓中" + dto.getCatchedNum() + "只 得分" + dto.getScore() + " 连抓" + dto.getContinuousCatchedNum() + "只 " + findPkResult(dto));
                    //查询对局详情  tb_time_limit_record
                    List<TimeLimitRecordDto> recordList = remoteTimeLimitRecordService.findByResultId(userId, dto.getId());
                    packageRecord(catchCoinDetailVO, recordList, dto.getStartTime());
                    catchCoinDetailVO.setVideoUrl(dto.getVideoUrl());
                    WawaCatcherSimpleDto catcher = remoteWawaCatcherService.find(dto.getCatcherId());
                    if (catcher != null) {
                        catchCoinDetailVO.setCatcherName(catcher.getCatcherName());
                    }
                }
                catchCoinDetailVO.setDetail("限时玩法-1v1");
                catchCoinDetailVO.setJoinOrderId(relationId.toString());
                catchCoinDetailVO.setRechargeNum(userCoinRecordDto.getCoin() == null ? "0" : "-" + userCoinRecordDto.getCoin());
            } else if (checkIsAddCoinType(userCoinRecordDto.getChangeType())) {
                Long relationId = userCoinRecordDto.getRelationId();
                AddCoinDto dto = remoteAddCoinService.find(relationId);
                if (dto != null) {
                    catchCoinDetailVO.setDetail("加币--" + AccountChangeTypeEnum.get(userCoinRecordDto.getChangeType()).desc());
                    catchCoinDetailVO.setCatcherStatus(dto.getAddComment() + "--" + addCoinService.getAccount().get(dto.getOperatorEmail()));
                }
            } else if (userCoinRecordDto.getChangeType() == AccountChangeTypeEnum.PK_WIN_ADD_COIN.value()) {
                Long relationId = userCoinRecordDto.getRelationId();
                TimeLimitResultRecordDto dto = timeLimitResultRecordService.find(relationId);
                if (dto != null) {
                    //查询是否胜利 tb_wawa_battle
                    String result = findPkResult(dto);
                    catchCoinDetailVO.setCatcherStatus(result);
                }
            }
            catchCoinDetailVO.setRechargeTime(DateUtils.getSecondStr(userCoinRecordDto.getGmtCreate()));

            return catchCoinDetailVO;
        }).collect(Collectors.toList());

        PagerResponse resultBase = new PagerResponse();
        resultBase.setRecords(catchCoinDetailVOS);
        resultBase.setTotalRecords(count);
        resultBase.setPageIndex(queryBean.getPageIndex());
        resultBase.setPageSize(queryBean.getPageSize());
        return resultBase;
    }

    private boolean checkIsAddCoinType(Integer changeType) {
        //通过管理后台加币
        if(changeType == AccountChangeTypeEnum.DELIVERY_COMPENSATE.value()
                || changeType == AccountChangeTypeEnum.SYSTEM_ERROR_COMPENSATE.value()
                || changeType == AccountChangeTypeEnum.TIME_LIMIT_APPEAL_COMPENSATE.value()
                || changeType == AccountChangeTypeEnum.LOGISTICS_ERROR_COMPENSATE.value()
                || changeType == AccountChangeTypeEnum.SPECIAL_REASONS_COMPENSATE.value()
                || changeType == AccountChangeTypeEnum.USER_SURVEY_ADD_COIN.value()){
            return true;
        }
        return false;
    }

    private String findPkResult(TimeLimitResultRecordDto dto) {
        Long resultId = dto.getId();
        Long battleId = dto.getBattleId();
        TimeLimitResultRecordDto battleDto = timeLimitResultRecordService.findBattleDtoByIdAndBattleId(battleId,resultId);
        if (null == battleDto){
            return EQUAL;
        }else{
            if(dto.getScore().intValue() == battleDto.getScore().intValue()){
                return EQUAL;
            }else if(dto.getScore().intValue() > battleDto.getScore().intValue()){
                return WIN;
            }else {
                return LOSE;
            }
        }
    }

    private void packageRecord(CatchCoinDetailVO catchCoinDetailVO, List<TimeLimitRecordDto> recordList, Date startTime) {
        if (CollectionUtils.isEmpty(recordList)) {
            return;
        }
        List<TimeLimitRecordVO> voList = new ArrayList<>(recordList.size());
        for (TimeLimitRecordDto dto : recordList) {
            TimeLimitRecordVO vo = new TimeLimitRecordVO();
            if(dto.getEndTime() == null || dto.getStartTime() == null || startTime == null){
                continue;
            }
            Long t = dto.getEndTime() - startTime.getTime();
            Long second = t / 1000;
            vo.setTime(second / 60 + ":" + second % 60);
            vo.setCatchResult(dto.getCatchResult());
            voList.add(vo);
        }
        catchCoinDetailVO.setRemarkRecords1v1(voList);
    }

    private String getStatusDesc(Integer status) {
        if (status == null || 0 == status) {
            return "未判定";
        }
        String desc = JoinOrderStatusEnum.get(status).desc();
        return desc;
    }

    /**
     * @param userId
     * @author zhanglihui
     */
    public boolean reset(Long userId) {
        return remoteUserManagerService.reset(userId);
    }

    public long conversionPercent(WawaDto wawaDto) {
        if (null == wawaDto || wawaDto.getPrice() == null || wawaDto.getPrimeCost() == null) {
            return 0l;
        }
        long primeCost = wawaDto.getPrimeCost();
        long price = wawaDto.getPrice();
        //α为返奖率，产品定义
        float α = (float) (wawaDto.getReturnAwardRate() * 0.0001);
        if (null == wawaDto.getReturnAwardRate() || wawaDto.getReturnAwardRate() == 0) {
            α = 0.75f;
        }
        int λ = 13;
        BigDecimal dev = new BigDecimal(primeCost)
                .divide(new BigDecimal(100), 2, BigDecimal.ROUND_HALF_UP)
                .add(new BigDecimal(5))
                .multiply(new BigDecimal(λ));
        BigDecimal strongPercent = new BigDecimal(price).multiply(new BigDecimal(α)).divide(dev, 4, BigDecimal.ROUND_HALF_UP);
        long conversionMoney = new BigDecimal(0.6f).multiply(new BigDecimal(wawaDto.getPrice())).divide(strongPercent, 0, RoundingMode.HALF_UP).longValue();
//        LOG.warn("可兑换币数量为 conversionMoney={} strongRate={} price={} userId={}",conversionMoney,strongPercent.doubleValue(),wawaEntity.getPrice());
        return conversionMoney;
    }

    public boolean writeUserIdsToOutput(UserManagerQuery userManagerQuery, HttpServletResponse response)throws IOException{
        Future<Boolean> result = executorService.submit(() -> {
            response.setContentType("application/csv;charset=UTF-8");
            String fileName = "vip用户-"+new Date().getTime() + ".txt";
            try (
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(response.getOutputStream()))
            ){
                response.setHeader("Content-Disposition", "attachment;filename="+ new String(fileName.getBytes(), "UTF-8"));
                int pageSize = 500;
                int pageIndex = 1;
                PagerRequest pagerRequest = new PagerRequest(pageIndex , pageSize);
                Set<Long> resutlIds = new HashSet<>();
                List<Long> ids = remoteUserManagerService.findUserIdsByQuery(userManagerQuery,pagerRequest);
                resutlIds.addAll(ids);
                while (ids != null && ids.size() == pageSize && resutlIds.size() <= EXPORT_MAX_COUNT){
                    pageIndex ++;
                    pagerRequest.setPageIndex(pageIndex);
                    ids = remoteUserManagerService.findUserIdsByQuery(userManagerQuery,pagerRequest);
                    resutlIds.addAll(ids);
                }
                writeIds(resutlIds,writer);
                writer.flush();
            } catch (IOException e) {
                LOGGER.warn("文件导出失败", e);

            }
            LOGGER.warn("文件导出成功");
            return Boolean.TRUE;
        });

        //防止线程池任务未结束,但是结果已经返回,所以这边使用callBack调用future的get阻塞一下,保证流的数据完整性
        boolean export;
        try {
            export = result.get();
            LOGGER.info("导出结果为 result={}",export);
        } catch (InterruptedException e) {
            LOGGER.error("thread interrupted msg={}",e);
            Thread.currentThread().interrupt();
            export = false;
        } catch (ExecutionException e) {
            LOGGER.error("export data error msg={}",e);
            export = false;
        }
        return export;

    }

    private void writeIds(Set<Long> ids,Writer writer ) throws IOException {
        if(CollectionUtils.isNotEmpty(ids)){
            for(Long id : ids){
                if(id != null){
                    writer.write(id.toString());
                    writer.write(",");
                }
            }

        }
    }
}
