package cn.com.wawa.manager.biz.service;

import cn.com.wawa.manager.biz.vo.title.UserTitleVO;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.title.UserTitleDto;
import cn.com.wawa.service.api.remoteservice.title.RemoteUserTitleService;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class UserTitleService {

    @Resource
    private RemoteUserTitleService remoteUserTitleService;

    public JsonResult<PagerResponse<UserTitleVO>> page(PagerRequest pagerRequest, Integer usedStatus, Integer status) {
        PagerResponse<UserTitleDto> page = remoteUserTitleService.page(pagerRequest, usedStatus, status);
        List<UserTitleVO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(page.getRecords())) {
            for (UserTitleDto dto : page.getRecords()) {
                list.add(new UserTitleVO(dto));
            }
        }
        return JsonResult.successResult(new PagerResponse<>(page, list));
    }
}
