package cn.com.wawa.manager.biz.service;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.WawaLandingPageDto;
import cn.com.wawa.service.api.remoteservice.RemoteWawaLandingPageService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class WawaLandingPageService {
    @Resource
    private RemoteWawaLandingPageService remoteWawaLandingPageService;

    public PagerResponse<WawaLandingPageDto> page(Integer pageIndex, Integer pageSize) {
        PagerRequest pagerRequest = new PagerRequest(pageIndex == null ? 1 : pageIndex, pageSize == null ? 20 : pageSize);
        return remoteWawaLandingPageService.page(pagerRequest);
    }

    public JsonResult delete(Long id) {
        return remoteWawaLandingPageService.delete(id);
    }

    public JsonResult save(WawaLandingPageDto dto) {
        return remoteWawaLandingPageService.insert(dto);
    }

    public WawaLandingPageDto find(Long id) {
        return remoteWawaLandingPageService.find(id);
    }
}
