package cn.com.wawa.manager.biz.service;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.manager.biz.bean.WinOrderAduitBean;
import cn.com.wawa.manager.biz.bean.WinOrderReceiveBean;
import cn.com.wawa.manager.biz.vo.VirtualGoodsReceiveVo;
import cn.com.wawa.manager.biz.vo.WinOrderVO;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.JoinOrderDto;
import cn.com.wawa.service.api.dto.VirtualGoodsReceiveDto;
import cn.com.wawa.service.api.dto.WinOrderDto;
import cn.com.wawa.service.api.dto.WinOrderReceiveDto;
import cn.com.wawa.service.api.enums.WinOrderStatusEnum;
import cn.com.wawa.service.api.remoteservice.RemoteJoinOrderService;
import cn.com.wawa.service.api.remoteservice.RemoteWinOrderService;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * Created by gyf .
 * 2017/10/31 .
 */
@Service("winOrderService")
public class WinOrderService {

    public static final int ADUITED = 1;//已审核

    public static final int NO_ADUIT = 0; //未审核

    public static final int PAST_ADUIT = 2; //审核超过2小时

    @Autowired
    private RemoteWinOrderService remoteWinOrderService;
    @Autowired
    private RemoteJoinOrderService remoteJoinOrderService;

    /**
     * 分页列表查询
     *
     * @param pageIndex
     * @param pageSize
     * @param userId
     * @param winOrderId
     * @return
     */
    public PagerResponse<WinOrderVO> page(Integer pageIndex, Integer pageSize, Long userId, Long winOrderId, String catcherName, String wawaName, String beginTime, String endTime, Integer type) {
        PagerRequest pagerRequest = new PagerRequest(pageIndex, pageSize);

        PagerResponse<WinOrderDto> page = remoteWinOrderService.page(userId, winOrderId, catcherName, wawaName, beginTime, endTime, type, pagerRequest);
        List<WinOrderDto> dtos = page.getRecords();
        if (!CollectionUtils.isEmpty(dtos)) {
            packageVideoUrl(dtos);
            Date now = new Date();
            for (WinOrderDto winOrderDto : dtos){
                if (winOrderDto.getWinOrderStatus() == WinOrderStatusEnum.CHECK.value() && winOrderDto.getAudit() == NO_ADUIT &&
                        now.after(DateUtils.hoursAddOrSub(winOrderDto.getGmtCreate(), 2))){
                    winOrderDto.setAudit(PAST_ADUIT);
                }
            }
        }
        return new PagerResponse<>(page, BeanUtils.copyList(dtos, WinOrderVO.class));
    }

    private List<WinOrderDto> packageVideoUrl(List<WinOrderDto> dtos) {
        Set<Long> ids = new HashSet<>();
        for (WinOrderDto winOrderDto : dtos) {
            ids.add(winOrderDto.getOrderId());
        }
        if (!CollectionUtils.isEmpty(ids)) {
            List<JoinOrderDto> orders = remoteJoinOrderService.findByIds(ids);
            if (!CollectionUtils.isEmpty(orders)) {
                Map<Long, JoinOrderDto> dataMap = new HashMap<>();
                for (JoinOrderDto order : orders) {
                    dataMap.put(order.getId(), order);
                }
                for (WinOrderDto winOrderDto : dtos) {
                    JoinOrderDto joinOrderDto = dataMap.get(winOrderDto.getOrderId());
                    if (joinOrderDto != null) {
                        winOrderDto.setVideoUrl(joinOrderDto.getVideoUrl());
                        //需要展示用户实际抓取实际
                        winOrderDto.setGmtCreate(joinOrderDto.getGmtCreate());
                    }
                }
            }
        }
        return dtos;
    }

    /**
     * 收回娃娃
     *
     * @param bean
     * @return
     */
    public Boolean confiscate(WinOrderReceiveBean bean) {
        WinOrderReceiveDto dto = BeanUtils.copy(bean, WinOrderReceiveDto.class);
        dto.setReceiceTime(new Date());
        return remoteWinOrderService.confiscate(dto);
    }

    /**
     * 更新娃娃数量
     *
     * @param winOrderId
     * @param quantity
     * @return
     */
    public Boolean updateQuantity(Long winOrderId, Integer quantity) {
        return remoteWinOrderService.updateQuantity(winOrderId, quantity);
    }

    public Boolean receive(VirtualGoodsReceiveVo bean) {
        Preconditions.checkNotNull(bean, "入参不能为空");
        Preconditions.checkNotNull(bean.getId(), "订单id不能为空");
        return remoteWinOrderService.receiveVirtualGoods(BeanUtils.copy(bean, VirtualGoodsReceiveDto.class));
    }

    public WinOrderDto getBeforeWinOrder(Long winOrderId, Long catcherId) {
        return remoteWinOrderService.getBeforeWinOrder(winOrderId, catcherId);
    }

    public WinOrderDto getAfterWinOrder(Long winOrderId, Long catcherId) {
        return remoteWinOrderService.getAfterWinOrder(winOrderId, catcherId);
    }

    /**
     * 收回娃娃
     *
     * @param bean
     * @return
     */
    public Boolean audit(WinOrderAduitBean bean) {
        WinOrderDto dto = BeanUtils.copy(bean, WinOrderDto.class);
        dto.setAudit(ADUITED);
        return remoteWinOrderService.audit(dto);
    }
}
