package cn.com.wawa.manager.biz.task;

import cn.com.wawa.manager.biz.bean.DeliveryOrderExportBean;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by danke on 2017/12/5.
 */
@Component
@Scope("prototype")
public class SendApplyExportRunnable implements Callable<Boolean>, ServletContextAware {

    Logger logger = LoggerFactory.getLogger(getClass());

    private ServletContext servletContext;

    private HttpServletResponse response;

    private String[]            colnums          = { "发货订单id", "原始单号", "商家编码", "货品数量", "娃娃名", "收件人", "手机", "省",
            "市", "区", "地址", "应收合计", "货品总价", "店铺名称", "订单类型", "发货方式"};

    private Long                taskId           = new Date().getTime();

    private Joiner joiner           = Joiner.on(",").useForNull("");

    private static final String STATISTICS = "/statistics/";

    private static final String SEPARATOR = "/";

    private List<DeliveryOrderExportBean> deliveryOrderExportBeans;

    /**
     * 初始化
     *
     * @return 任务号
     */
    public Map<String, Object> init() {
        String webRootDir = servletContext.getRealPath(SEPARATOR);
        File userDir = new File(webRootDir, STATISTICS);
        if (!userDir.exists()) {
            userDir.mkdirs();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(new Date().getTime()).append(".csv");
        File file = new File(userDir, sb.toString());

        Map<String, Object> info = Maps.newHashMap();
        info.put("taskId", taskId.toString());
        info.put("fileName", file.getName());
        return info;
    }

    @Override
    public Boolean call() throws Exception {
        response.setContentType("application/csv;charset=UTF-8");
        String fileName = new Date().getTime() + ".csv";
        try (
                ServletOutputStream out = response.getOutputStream();
        ){
            response.setHeader("Content-Disposition", "attachment;filename="+ new String(fileName.getBytes(), "UTF-8"));
            OrderSnapshotToString trsform = new OrderSnapshotToString();
            List<String> list = Lists.transform(deliveryOrderExportBeans, trsform);
            List<String> headers = Lists.newArrayList();
            headers.add(joiner.join(colnums));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < headers.size();i++){
                sb.append(headers.get(i));
                if (i< (headers.size() -1))
                    sb.append(",");
            }
            //换成do while循环,保证至少有头输出
            String header=sb.toString();
            StringBuilder contentStr = new StringBuilder();
            // 文件头加上BOM信息，防止导出乱码
            contentStr.append(header).append("\n");//append(new String(new byte[] { (byte) 0xEF, (byte) 0xBB,(byte) 0xBF }))
            if (CollectionUtils.isNotEmpty(list)){
                for (String rows:list){
                    contentStr.append(rows).append("\n");
                }
            }
            byte[] contentByte=contentStr.toString().getBytes("GB2312");
            InputStream is = new ByteArrayInputStream(contentByte);
            readWrite(is,out);
        } catch (IOException e) {
            logger.warn("文件导出失败", e);

        }
        logger.warn("文件导出成功");
        return Boolean.TRUE;
    }

    private class OrderSnapshotToString implements Function<DeliveryOrderExportBean, String> {

        @Override
        public String apply(DeliveryOrderExportBean input) {
            List<String> row = Lists.newArrayList();
            row.add(useForNull(input.getId()));//发货订单id
            row.add(useForNull(1));//原始单号
            row.add(useForNull(input.getUserCatchedWawaDto().getDeliveryNum()));//商家编码
            row.add(useForNull(1));//货品数量
            row.add(useForNull(input.getUserCatchedWawaDto().getWawaName()));//娃娃名
            row.add(useForNull(input.getReveiver()));//收件人
            row.add(useForNull(input.getPhone()));//手机
            row.add(useForNull(input.getAddrProvince()));//省
            row.add(useForNull(input.getAddrCity()));//市
            row.add(useForNull(input.getAddrArea()));//区
            row.add(useForNull(input.getAddrDetail()));//详细地址
            row.add(useForNull(0));//应收合计
            row.add(useForNull(0));//货品总价
            row.add(useForNull("每日必败"));//店铺名称
            row.add(useForNull("款到发货"));//订单类型
            row.add(useForNull("款到发货"));//发货方式
            return joiner.join(row);
        }

        private String useForNull(Object obj) {
            StringBuilder builder = new StringBuilder();
            builder.append("\"");
            if (Objects.equal(null, obj)) {
                builder.append("");
            } else {
                builder.append(obj.toString());
            }
            builder.append("\"");
            return builder.toString();
        }
    }


    public void readWrite(InputStream is, ServletOutputStream out){
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            BufferedOutputStream bos = new BufferedOutputStream(out);
            byte[] buff = new byte[2048];
            int bytesRead;
            // Simple read/write loop.
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            bos.flush();
        } catch (final IOException e) {
            logger.error("readwrite error msg={}",e);
        }
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setDeliveryOrderExportBeans(List<DeliveryOrderExportBean> deliveryOrderExportBeans) {
        this.deliveryOrderExportBeans = deliveryOrderExportBeans;
    }

}
