package cn.com.wawa.manager.biz.tools;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * Environment
 */
@Component
public class EnvironmentUtil {

    public static final String PROD = "prod";
    public static final String PRE = "pre";
    public static final String TEST  = "test";
    public static final String DEV    = "dev";


    private static String env;

	/**
	 * 私有构造器
     */
    private EnvironmentUtil(){
        // Do nothing because of X and Y.
    }

    @Value("${spring.profiles.active}")
    public void setEnv(String env) {
        EnvironmentUtil.env = env;
    }

    public static String getEnv() {
        return env;
    }

    public static boolean isProd() {
        return PROD.equals(env);
    }

    public static boolean isPre() {
        return PRE.equals(env);
    }

    public static boolean isTest() {
        return TEST.equals(env);
    }

    public static boolean isDev() {
        return DEV.equals(env);
    }
}
