package cn.com.wawa.manager.biz.tools;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LocalDateUtil {

    private static final Logger LOG = LoggerFactory.getLogger(LocalDateUtil.class);

    private static final SimpleDateFormat HOUR = getFormat("yyyy-MM-dd HH");

    private static final SimpleDateFormat FULL_DATE = getFormat("yyyy-MM-dd HH:mm:ss");


    /**
     * method : 10、根据Date获取"yyyy-MM-dd HH:mm"字符串
     */
    public static String getHourStr(Date date) {
        synchronized (HOUR) {
            return getStr(date, HOUR);
        }
    }

    /**
     * method : 4、根据"yyyyMMdd-HHmm"字符串 获取 Date类型
     */
    public static Date getHoruDbDate(String str) {
        synchronized (HOUR) {
            return getDate(str, HOUR);
        }
    }

    public static Date getFullDate(String str) {
        synchronized (FULL_DATE) {
            return getDate(str, FULL_DATE);
        }
    }

    private static Date getDate(String dateStr, SimpleDateFormat format) {
        if ("".equals(dateStr) || dateStr == null)
            return null;
        try {
            return format.parse(dateStr);
        } catch (ParseException e) {
            LOG.error("format yyyy-MM-dd HH:mm:ss error:", e);
        }
        return null;
    }

    private static SimpleDateFormat getFormat(String format) {
        return new SimpleDateFormat(format);
    }

    private static String getStr(Date date, SimpleDateFormat format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }
}
