package cn.com.wawa.manager.biz.vo;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.service.api.dto.BigPopDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel(value = "大弹窗")
public class BigPopVO {
    private Long id;

    private String image;

    private String name;

    private Long payload;

    private String onTime;

    private String offTime;

    private Integer status;

    private String gmtCreate;

    private String gmtModified;
    private BigDecimal wide;
    private BigDecimal height;

    private Integer click;
    private Integer isClosed;

    private Integer clientType;

    private Long minVersionCode;

    private Long maxVersionCode;

    @ApiModelProperty("弹窗类型,1引导点击弹窗、2非引导点击弹窗、3翻翻卡  4 h5弹窗")
    private Integer bigPopType;

    @ApiModelProperty("点击热区1类型 1不跳转、2跳转版本更新、3h5链接、原生页面链接、4调起快捷充值弹窗、5调起推送权限获取弹窗")
    private Integer leftBtnType;
    @ApiModelProperty("点击热区1后是否关闭 0否 1是")
    private Integer leftBtnClose;
    @ApiModelProperty("点击热区1后跳转地址")
    private String leftBtnUrl;

    @ApiModelProperty("点击热区2类型 1不跳转、2跳转版本更新、3h5链接、原生页面链接、4调起快捷充值弹窗、5调起推送权限获取弹窗")
    private Integer rightBtnType;
    @ApiModelProperty("点击热区2后是否关闭 0否 1是")
    private Integer rightBtnClose;
    @ApiModelProperty("点击热区2后跳转地址")
    private String rightBtnUrl;

    public BigPopVO() {
    }

    public BigPopVO(BigPopDto bigPopDto) {
        this.id=bigPopDto.getId();
        this.image=bigPopDto.getImage();
        this.name=bigPopDto.getName();
        this.payload=bigPopDto.getPayload();
        this.wide=bigPopDto.getWide();
        this.height=bigPopDto.getHeight();
        this.click=bigPopDto.getClick();
        this.isClosed=bigPopDto.getIsClosed();
        if(bigPopDto.getOnTime()!=null){
            this.onTime= DateUtils.getSecondStr(bigPopDto.getOnTime());
        }
        if(bigPopDto.getOffTime()!=null){
            this.offTime=DateUtils.getSecondStr(bigPopDto.getOffTime());
        }
        this.status=bigPopDto.getStatus();
        this.gmtCreate=DateUtils.getSecondStr(bigPopDto.getGmtCreate());
        this.gmtModified=DateUtils.getSecondStr(bigPopDto.getGmtCreate());
        this.clientType=bigPopDto.getClientType();
        this.maxVersionCode=bigPopDto.getMaxVersionCode();
        this.minVersionCode=bigPopDto.getMinVersionCode();

        this.leftBtnUrl=bigPopDto.getLeftBtnUrl();
        this.leftBtnClose=bigPopDto.getLeftBtnClose();
        this.leftBtnType=bigPopDto.getLeftBtnType();
        this.rightBtnClose=bigPopDto.getRightBtnClose();
        this.rightBtnType=bigPopDto.getRightBtnType();
        this.rightBtnUrl=bigPopDto.getRightBtnUrl();
        this.bigPopType=bigPopDto.getBigPopType();
    }

}
