package cn.com.wawa.manager.biz.vo;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.service.api.dto.FloorDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("楼层图片信息")
public class FloorVO {
    private Long id;

    private String image;

    private String url;

    private String floorName;

    private Long payload;

    private Integer floorStatus;

    private String gmtCreate;

    private String gmtModified;

    @ApiModelProperty("0，全部用户，1,新用户(没抓中过) 2、抓中过的用户")
    private Integer userType;

    @ApiModelProperty("定向Id")
    private Long redirectId;


    public FloorVO() {
    }

    public FloorVO(FloorDto floorDto) {
        this.id = floorDto.getId();
        this.image = floorDto.getImage();
        this.url = floorDto.getUrl();
        this.floorName = floorDto.getFloorName();
        this.payload = floorDto.getPayload();
        this.floorStatus = floorDto.getFloorStatus();
        this.gmtCreate = DateUtils.getSecondStr(floorDto.getGmtCreate());
        this.gmtModified = DateUtils.getSecondStr(floorDto.getGmtCreate());
        this.userType = floorDto.getUserType();
        this.redirectId = floorDto.getRedirectId();
    }

}
