package cn.com.wawa.manager.biz.vo;

import cn.com.wawa.service.api.dto.RankInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("查看排行榜")
public class RankInfoVO {
    @ApiModelProperty("排名")
    private Integer ranking;
    @ApiModelProperty("用户ID")
    private Long userId;
    @ApiModelProperty("昵称")
    private String nickName;
    @ApiModelProperty("活动期间充值金额")
    private Long chargeMoney;
    @ApiModelProperty("活动期间抓中娃娃数")
    private Integer wawaCount;
    @ApiModelProperty("历史充值金额")
    private Long chargeMoneyHistory;
    @ApiModelProperty("历史抓中娃娃数")
    private Integer wawaCountHistory;
    @ApiModelProperty("奖品")
    private String award;

    public RankInfoVO() {
    }


    public RankInfoVO(RankInfoDto rankInfoDto) {
        this.ranking = rankInfoDto.getRanking();
        this.userId = rankInfoDto.getUserId();
        this.nickName = rankInfoDto.getNickName();
        this.chargeMoney = rankInfoDto.getChargeMoney();
        this.wawaCount = rankInfoDto.getWawaCount();
        this.chargeMoneyHistory = rankInfoDto.getChargeMoneyHistory();
        this.wawaCountHistory = rankInfoDto.getWawaCountHistory();
        this.award = rankInfoDto.getAward();
    }

}
