package cn.com.wawa.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "任务详情")
public class RewardTaskVO {

    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 任务名称
     */
    @ApiModelProperty(value = "任务备注")
    private String taskName;


    /**
     * 数量
     */
    @ApiModelProperty(value = "出发条件的数量")
    private Integer num;
    /**
     * 1:抓取； 2:抓中了  (configType=2时有效)
     */
    @ApiModelProperty(value = "每日任务时 1:抓取； 2:抓中")
    private Integer state;
    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer rank;
    /**
     * 奖励内容(json)
     * 要加概率
     */
    @ApiModelProperty(value = "奖品配置")
    private List<cn.com.wawa.service.api.bean.RewardPrizeJsonBean> prizeJsonList;
    /**
     * 类型 1:抽奖宝箱 2:每日任务 3:活跃度
     */
    @ApiModelProperty(value = "类型 1:抽奖宝箱 2:每日任务 3:活跃度")
    private Integer taskType;
    /**
     * 上架日期
     */
    @ApiModelProperty(value = "上架日期")
    private String startTime;
    /**
     * 下架日期
     */
    @ApiModelProperty(value = "下架日期")
    private String endTime;

    @ApiModelProperty(value = "抽奖id")
    private Long luckDrawId;

    @ApiModelProperty(value = "抽奖次数")
    private Integer luckDrawNum;
    @ApiModelProperty(value = "活动id")
    private Long templateId;

}
