package cn.com.wawa.manager.biz.vo;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.service.api.dto.RewardPrizeDto;
import cn.com.wawa.service.api.dto.RewardTempDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "活动管理详情")
public class RewardTempVO {

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 活动主题
     */
    @ApiModelProperty(value = "活动名称")
    private String theme;
    /**
     * 活动开始时间
     */
    @ApiModelProperty(value = "活动开始时间")
    private String startTime;
    /**
     * 活动结束时间
     */
    @ApiModelProperty(value = "活动结束时间")
    private String endTime;


    public RewardTempVO() {
    }

    public RewardTempVO(RewardTempDto dto) {
        this.id = dto.getId();
        this.theme = dto.getTheme();
        if (dto.getStartTime() != null) {
            this.startTime = DateUtils.getSecondStr(dto.getStartTime());
        }
        if (dto.getEndTime() != null) {
            this.endTime = DateUtils.getSecondStr(dto.getEndTime());
        }
    }

}
