package cn.com.wawa.manager.biz.vo;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.service.api.dto.RoomBuoyDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("房间浮标信息")
public class RoomBuoyVO {
    private Long id;
    @ApiModelProperty("浮标名称")
    private String buoyName;
    @ApiModelProperty("图片地址")
    private String img;
    @ApiModelProperty("链接")
    private String link;
    @ApiModelProperty("充值后上线状态 1.上线 2.下线")
    private Integer chargeState;
    @ApiModelProperty("充值金额")
    private Long chargeMoney;
    @ApiModelProperty("定向id")
    private Long orientationId;
    private String gmtCreate;
    private String gmtModified;
    @ApiModelProperty("上线时间")
    private String onlineTime;
    @ApiModelProperty("下线时间")
    private String offlineTime;
    @ApiModelProperty("平台类型: 0.全部 1.IOS 2.安卓 3.h5")
    private Integer clientType;
    @ApiModelProperty("最小版本")
    private Long minVersionCode;
    @ApiModelProperty("最大版本")
    private Long maxVersionCode;
    @ApiModelProperty("1上线2下线")
    private Integer state;


    public RoomBuoyVO() {
    }

    public RoomBuoyVO(RoomBuoyDto roomBuoyDto) {
        this.id = roomBuoyDto.getId();
        this.buoyName = roomBuoyDto.getBuoyName();
        this.img = roomBuoyDto.getImg();
        this.link = roomBuoyDto.getLink();
        this.chargeState = roomBuoyDto.getChargeState();
        this.chargeMoney = roomBuoyDto.getChargeMoney() / 100;
        this.orientationId = roomBuoyDto.getOrientationId();
        if (roomBuoyDto.getOnlineTime() != null) {
            this.onlineTime = DateUtils.getSecondStr(roomBuoyDto.getOnlineTime());
        }
        if (roomBuoyDto.getOfflineTime() != null) {
            this.offlineTime = DateUtils.getSecondStr(roomBuoyDto.getOfflineTime());
        }
        this.gmtCreate = DateUtils.getSecondStr(roomBuoyDto.getGmtCreate());
        this.gmtModified = DateUtils.getSecondStr(roomBuoyDto.getGmtCreate());
        this.clientType = roomBuoyDto.getClientType();
        this.maxVersionCode = roomBuoyDto.getMaxVersionCode();
        this.minVersionCode = roomBuoyDto.getMinVersionCode();
        this.state = roomBuoyDto.getState();
    }

}
