package cn.com.wawa.manager.biz.vo;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.service.api.dto.StartImageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("开屏图片列表")
public class StartImageVO {
    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("开屏图片名称")
    private String startImageName;
    @ApiModelProperty("图片url")
    private String image;
    @ApiModelProperty("跳转链接,不填则不跳转")
    private String url;
    @ApiModelProperty("排序权重")
    private Long payload;
    @ApiModelProperty("0，不限制，1,IOS 2、安卓")
    private Integer clientType;
    @ApiModelProperty("最小版本号")
    private Long minVersionCode;
    @ApiModelProperty("最大版本号")
    private Long maxVersionCode;
    @ApiModelProperty("开启时间")
    private String openTime;
    @ApiModelProperty("关闭时间")
    private String closeTime;
    @ApiModelProperty("开屏图片状态  1：开启 2 关闭")
    private Integer startImageStatus;
    @ApiModelProperty("创建时间")
    private String gmtCreate;
    @ApiModelProperty("修改时间")
    private String gmtModified;
    @ApiModelProperty("图片加长版")
    private String bigImage;

    public StartImageVO() {
    }

    public StartImageVO(StartImageDto startImageDto) {
        this.id=startImageDto.getId();
        this.image=startImageDto.getImage();
        this.url=startImageDto.getUrl();
        this.startImageName=startImageDto.getStartImageName();
        this.payload=startImageDto.getPayload();
        if(startImageDto.getOpenTime()!=null){
            this.openTime= DateUtils.getSecondStr(startImageDto.getOpenTime());
        }
        if(startImageDto.getCloseTime()!=null){
            this.closeTime=DateUtils.getSecondStr(startImageDto.getCloseTime());
        }
        this.startImageStatus=startImageDto.getStartImageStatus();
        this.gmtCreate=DateUtils.getSecondStr(startImageDto.getGmtCreate());
        this.gmtModified=DateUtils.getSecondStr(startImageDto.getGmtCreate());
        this.clientType=startImageDto.getClientType();
        this.maxVersionCode=startImageDto.getMaxVersionCode();
        this.minVersionCode=startImageDto.getMinVersionCode();
        this.bigImage=startImageDto.getBigImage();
    }


}
