package cn.com.wawa.manager.biz.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("限时玩法匹配场次详情")
public class TimeLimitPKConfigVO implements Serializable {

    /**
     * 场次名称  junior初级 middle中级 senior高级 master大师
     */
    @ApiModelProperty(value = "场次名称  junior初级 middle中级 senior高级 master大师")
    private String name;

    /**
     * 投注花费
     */
    @ApiModelProperty(value = "投注花费")
    private Integer price;

    /**
     * {"id":1,"name":"junior","price":100,"fee":10,"img":"","status":1,"gameTime":180,"matchRobot":1}
     */

    /**
     * 入口图片地址
     */
    @ApiModelProperty(value = "入口图片地址")
    private String img;

    /**
     * 费率  正整数
     */
    @ApiModelProperty(value = "费率  正整数")
    private Integer fee;

    /**
     * 状态 1上线 2下线
     */
    @ApiModelProperty(value = "状态 1上线 2下线")
    private Integer status;

    /**
     * 场次是否允许匹配机器人 1允许 0不允许
     */
    @ApiModelProperty(value = "场次是否允许匹配机器人 1允许 0不允许")
    private Integer matchRobot;

    private Integer id;

    /**
     * 游戏时长，单位：秒
     */
    @ApiModelProperty(value = "游戏时长，单位：秒")
    private Integer gameTime;

}
