package cn.com.wawa.manager.biz.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * Created by gyf . 2017/10/27 .
 */
@Data
@ApiModel("娃娃机对象")
public class WawaCatcherVO {

    @ApiModelProperty("娃娃机id")
    private Long    id;

    @ApiModelProperty("娃娃机名称")
    private String  catcherName;

    @ApiModelProperty("娃娃机上配置的价格/ 需要使用娃娃覆盖")
    private Long    price;

    @ApiModelProperty("娃娃机排序值")
    private Long    payload;

    @ApiModelProperty("娃娃id")
    private Long    wawaId;

    @ApiModelProperty("娃娃图")
    private String  indexImage;

    @ApiModelProperty("娃娃名称")
    private String  wawaName;

    @ApiModelProperty("状态 0下架 1上架")
    private Integer catcherStatus;

    @ApiModelProperty("健康状态 0健康 1不健康")
    private Integer healthStatus;

    @ApiModelProperty("最新一次上架时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date    lastOnshelfTime;

    @ApiModelProperty("娃娃总数")
    private Integer totality;

    @ApiModelProperty("娃娃剩余数量")
    private Integer stock;

    @ApiModelProperty("娃娃机版本号")
    private String  catcherVersion;
    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("排数")
    private Integer row;

    @ApiModelProperty("玩法类型 1.经典玩法 2.限时玩法")
    private Integer playType;
}
